/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.TimeSeriesMetricType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HistogramProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final TimeSeriesMetricType timeSeriesMetric;
    public static final JsonpDeserializer<HistogramProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HistogramProperty::setupHistogramPropertyDeserializer);

    private HistogramProperty(Builder builder) {
        super(builder);
        this.ignoreMalformed = builder.ignoreMalformed;
        this.timeSeriesMetric = builder.timeSeriesMetric;
    }

    public static HistogramProperty of(Function<Builder, ObjectBuilder<HistogramProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Histogram;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public final TimeSeriesMetricType timeSeriesMetric() {
        return this.timeSeriesMetric;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "histogram");
        super.serializeInternal(generator, mapper);
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.timeSeriesMetric != null) {
            generator.writeKey("time_series_metric");
            this.timeSeriesMetric.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupHistogramPropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(Builder::timeSeriesMetric, TimeSeriesMetricType._DESERIALIZER, "time_series_metric");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HistogramProperty> {
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private TimeSeriesMetricType timeSeriesMetric;

        public Builder() {
        }

        private Builder(HistogramProperty instance) {
            this.ignoreMalformed = instance.ignoreMalformed;
            this.timeSeriesMetric = instance.timeSeriesMetric;
        }

        public final Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public final Builder timeSeriesMetric(@Nullable TimeSeriesMetricType value) {
            this.timeSeriesMetric = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HistogramProperty build() {
            this._checkSingleUse();
            return new HistogramProperty(this);
        }
    }
}

