/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.TimeSeriesMetricType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExponentialHistogramProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final TimeSeriesMetricType timeSeriesMetric;
    public static final JsonpDeserializer<ExponentialHistogramProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExponentialHistogramProperty::setupExponentialHistogramPropertyDeserializer);

    private ExponentialHistogramProperty(Builder builder) {
        super(builder);
        this.timeSeriesMetric = builder.timeSeriesMetric;
    }

    public static ExponentialHistogramProperty of(Function<Builder, ObjectBuilder<ExponentialHistogramProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.ExponentialHistogram;
    }

    @Nullable
    public final TimeSeriesMetricType timeSeriesMetric() {
        return this.timeSeriesMetric;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "exponential_histogram");
        super.serializeInternal(generator, mapper);
        if (this.timeSeriesMetric != null) {
            generator.writeKey("time_series_metric");
            this.timeSeriesMetric.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupExponentialHistogramPropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::timeSeriesMetric, TimeSeriesMetricType._DESERIALIZER, "time_series_metric");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ExponentialHistogramProperty> {
        @Nullable
        private TimeSeriesMetricType timeSeriesMetric;

        public Builder() {
        }

        private Builder(ExponentialHistogramProperty instance) {
            this.timeSeriesMetric = instance.timeSeriesMetric;
        }

        public final Builder timeSeriesMetric(@Nullable TimeSeriesMetricType value) {
            this.timeSeriesMetric = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExponentialHistogramProperty build() {
            this._checkSingleUse();
            return new ExponentialHistogramProperty(this);
        }
    }
}

