/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CountedKeywordProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean index;
    public static final JsonpDeserializer<CountedKeywordProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CountedKeywordProperty::setupCountedKeywordPropertyDeserializer);

    private CountedKeywordProperty(Builder builder) {
        super(builder);
        this.index = builder.index;
    }

    public static CountedKeywordProperty of(Function<Builder, ObjectBuilder<CountedKeywordProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.CountedKeyword;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "counted_keyword");
        super.serializeInternal(generator, mapper);
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCountedKeywordPropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CountedKeywordProperty> {
        @Nullable
        private Boolean index;

        public Builder() {
        }

        private Builder(CountedKeywordProperty instance) {
            this.index = instance.index;
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CountedKeywordProperty build() {
            this._checkSingleUse();
            return new CountedKeywordProperty(this);
        }
    }
}

