/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UniqueTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Boolean onlyOnSamePosition;
    public static final JsonpDeserializer<UniqueTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UniqueTokenFilter::setupUniqueTokenFilterDeserializer);

    private UniqueTokenFilter(Builder builder) {
        super(builder);
        this.onlyOnSamePosition = builder.onlyOnSamePosition;
    }

    public static UniqueTokenFilter of(Function<Builder, ObjectBuilder<UniqueTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Unique;
    }

    @Nullable
    public final Boolean onlyOnSamePosition() {
        return this.onlyOnSamePosition;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "unique");
        super.serializeInternal(generator, mapper);
        if (this.onlyOnSamePosition != null) {
            generator.writeKey("only_on_same_position");
            generator.write(this.onlyOnSamePosition.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupUniqueTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::onlyOnSamePosition, JsonpDeserializer.booleanDeserializer(), "only_on_same_position");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UniqueTokenFilter> {
        @Nullable
        private Boolean onlyOnSamePosition;

        public Builder() {
        }

        private Builder(UniqueTokenFilter instance) {
            this.onlyOnSamePosition = instance.onlyOnSamePosition;
        }

        public final Builder onlyOnSamePosition(@Nullable Boolean value) {
            this.onlyOnSamePosition = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UniqueTokenFilter build() {
            this._checkSingleUse();
            return new UniqueTokenFilter(this);
        }
    }
}

