/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MinHashTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Integer bucketCount;
    @Nullable
    private final Integer hashCount;
    @Nullable
    private final Integer hashSetSize;
    @Nullable
    private final Boolean withRotation;
    public static final JsonpDeserializer<MinHashTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MinHashTokenFilter::setupMinHashTokenFilterDeserializer);

    private MinHashTokenFilter(Builder builder) {
        super(builder);
        this.bucketCount = builder.bucketCount;
        this.hashCount = builder.hashCount;
        this.hashSetSize = builder.hashSetSize;
        this.withRotation = builder.withRotation;
    }

    public static MinHashTokenFilter of(Function<Builder, ObjectBuilder<MinHashTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.MinHash;
    }

    @Nullable
    public final Integer bucketCount() {
        return this.bucketCount;
    }

    @Nullable
    public final Integer hashCount() {
        return this.hashCount;
    }

    @Nullable
    public final Integer hashSetSize() {
        return this.hashSetSize;
    }

    @Nullable
    public final Boolean withRotation() {
        return this.withRotation;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "min_hash");
        super.serializeInternal(generator, mapper);
        if (this.bucketCount != null) {
            generator.writeKey("bucket_count");
            generator.write(this.bucketCount.intValue());
        }
        if (this.hashCount != null) {
            generator.writeKey("hash_count");
            generator.write(this.hashCount.intValue());
        }
        if (this.hashSetSize != null) {
            generator.writeKey("hash_set_size");
            generator.write(this.hashSetSize.intValue());
        }
        if (this.withRotation != null) {
            generator.writeKey("with_rotation");
            generator.write(this.withRotation.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMinHashTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::bucketCount, JsonpDeserializer.integerDeserializer(), "bucket_count");
        op.add(Builder::hashCount, JsonpDeserializer.integerDeserializer(), "hash_count");
        op.add(Builder::hashSetSize, JsonpDeserializer.integerDeserializer(), "hash_set_size");
        op.add(Builder::withRotation, JsonpDeserializer.booleanDeserializer(), "with_rotation");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MinHashTokenFilter> {
        @Nullable
        private Integer bucketCount;
        @Nullable
        private Integer hashCount;
        @Nullable
        private Integer hashSetSize;
        @Nullable
        private Boolean withRotation;

        public Builder() {
        }

        private Builder(MinHashTokenFilter instance) {
            this.bucketCount = instance.bucketCount;
            this.hashCount = instance.hashCount;
            this.hashSetSize = instance.hashSetSize;
            this.withRotation = instance.withRotation;
        }

        public final Builder bucketCount(@Nullable Integer value) {
            this.bucketCount = value;
            return this;
        }

        public final Builder hashCount(@Nullable Integer value) {
            this.hashCount = value;
            return this;
        }

        public final Builder hashSetSize(@Nullable Integer value) {
            this.hashSetSize = value;
            return this;
        }

        public final Builder withRotation(@Nullable Boolean value) {
            this.withRotation = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MinHashTokenFilter build() {
            this._checkSingleUse();
            return new MinHashTokenFilter(this);
        }
    }
}

