/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LengthTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Integer max;
    @Nullable
    private final Integer min;
    public static final JsonpDeserializer<LengthTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LengthTokenFilter::setupLengthTokenFilterDeserializer);

    private LengthTokenFilter(Builder builder) {
        super(builder);
        this.max = builder.max;
        this.min = builder.min;
    }

    public static LengthTokenFilter of(Function<Builder, ObjectBuilder<LengthTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Length;
    }

    @Nullable
    public final Integer max() {
        return this.max;
    }

    @Nullable
    public final Integer min() {
        return this.min;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "length");
        super.serializeInternal(generator, mapper);
        if (this.max != null) {
            generator.writeKey("max");
            generator.write(this.max.intValue());
        }
        if (this.min != null) {
            generator.writeKey("min");
            generator.write(this.min.intValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupLengthTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::max, JsonpDeserializer.integerDeserializer(), "max");
        op.add(Builder::min, JsonpDeserializer.integerDeserializer(), "min");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<LengthTokenFilter> {
        @Nullable
        private Integer max;
        @Nullable
        private Integer min;

        public Builder() {
        }

        private Builder(LengthTokenFilter instance) {
            this.max = instance.max;
            this.min = instance.min;
        }

        public final Builder max(@Nullable Integer value) {
            this.max = value;
            return this;
        }

        public final Builder min(@Nullable Integer value) {
            this.min = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LengthTokenFilter build() {
            this._checkSingleUse();
            return new LengthTokenFilter(this);
        }
    }
}

