/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class IcuFoldingTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final String unicodeSetFilter;
    public static final JsonpDeserializer<IcuFoldingTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuFoldingTokenFilter::setupIcuFoldingTokenFilterDeserializer);

    private IcuFoldingTokenFilter(Builder builder) {
        super(builder);
        this.unicodeSetFilter = ApiTypeHelper.requireNonNull(builder.unicodeSetFilter, this, "unicodeSetFilter");
    }

    public static IcuFoldingTokenFilter of(Function<Builder, ObjectBuilder<IcuFoldingTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.IcuFolding;
    }

    public final String unicodeSetFilter() {
        return this.unicodeSetFilter;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_folding");
        super.serializeInternal(generator, mapper);
        generator.writeKey("unicode_set_filter");
        generator.write(this.unicodeSetFilter);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIcuFoldingTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::unicodeSetFilter, JsonpDeserializer.stringDeserializer(), "unicode_set_filter");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IcuFoldingTokenFilter> {
        private String unicodeSetFilter;

        public Builder() {
        }

        private Builder(IcuFoldingTokenFilter instance) {
            this.unicodeSetFilter = instance.unicodeSetFilter;
        }

        public final Builder unicodeSetFilter(String value) {
            this.unicodeSetFilter = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IcuFoldingTokenFilter build() {
            this._checkSingleUse();
            return new IcuFoldingTokenFilter(this);
        }
    }
}

