/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MultiTermLookup
implements JsonpSerializable {
    private final String field;
    @Nullable
    private final FieldValue missing;
    public static final JsonpDeserializer<MultiTermLookup> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiTermLookup::setupMultiTermLookupDeserializer);

    private MultiTermLookup(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.missing = builder.missing;
    }

    public static MultiTermLookup of(Function<Builder, ObjectBuilder<MultiTermLookup>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final FieldValue missing() {
        return this.missing;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMultiTermLookupDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::missing, FieldValue._DESERIALIZER, "missing");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MultiTermLookup> {
        private String field;
        @Nullable
        private FieldValue missing;

        public Builder() {
        }

        private Builder(MultiTermLookup instance) {
            this.field = instance.field;
            this.missing = instance.missing;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder missing(@Nullable FieldValue value) {
            this.missing = value;
            return this;
        }

        public final Builder missing(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.missing(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder missing(String value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(long value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(double value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(boolean value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiTermLookup build() {
            this._checkSingleUse();
            return new MultiTermLookup(this);
        }
    }
}

