/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IpPrefixBucket
extends MultiBucketBase {
    private final boolean isIpv6;
    private final String key;
    private final int prefixLength;
    @Nullable
    private final String netmask;
    public static final JsonpDeserializer<IpPrefixBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IpPrefixBucket::setupIpPrefixBucketDeserializer);

    private IpPrefixBucket(Builder builder) {
        super(builder);
        this.isIpv6 = ApiTypeHelper.requireNonNull(builder.isIpv6, (Object)this, "isIpv6", false);
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
        this.prefixLength = ApiTypeHelper.requireNonNull(builder.prefixLength, (Object)this, "prefixLength", 0);
        this.netmask = builder.netmask;
    }

    public static IpPrefixBucket of(Function<Builder, ObjectBuilder<IpPrefixBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean isIpv6() {
        return this.isIpv6;
    }

    public final String key() {
        return this.key;
    }

    public final int prefixLength() {
        return this.prefixLength;
    }

    @Nullable
    public final String netmask() {
        return this.netmask;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("is_ipv6");
        generator.write(this.isIpv6);
        generator.writeKey("key");
        generator.write(this.key);
        generator.writeKey("prefix_length");
        generator.write(this.prefixLength);
        if (this.netmask != null) {
            generator.writeKey("netmask");
            generator.write(this.netmask);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIpPrefixBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::isIpv6, JsonpDeserializer.booleanDeserializer(), "is_ipv6");
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::netmask, JsonpDeserializer.stringDeserializer(), "netmask");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IpPrefixBucket> {
        private Boolean isIpv6;
        private String key;
        private Integer prefixLength;
        @Nullable
        private String netmask;

        public Builder() {
        }

        private Builder(IpPrefixBucket instance) {
            this.isIpv6 = instance.isIpv6;
            this.key = instance.key;
            this.prefixLength = instance.prefixLength;
            this.netmask = instance.netmask;
        }

        public final Builder isIpv6(boolean value) {
            this.isIpv6 = value;
            return this;
        }

        public final Builder key(String value) {
            this.key = value;
            return this;
        }

        public final Builder prefixLength(int value) {
            this.prefixLength = value;
            return this;
        }

        public final Builder netmask(@Nullable String value) {
            this.netmask = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IpPrefixBucket build() {
            this._checkSingleUse();
            return new IpPrefixBucket(this);
        }
    }
}

