/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HdrMethod
implements JsonpSerializable {
    @Nullable
    private final Integer numberOfSignificantValueDigits;
    public static final JsonpDeserializer<HdrMethod> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HdrMethod::setupHdrMethodDeserializer);

    private HdrMethod(Builder builder) {
        this.numberOfSignificantValueDigits = builder.numberOfSignificantValueDigits;
    }

    public static HdrMethod of(Function<Builder, ObjectBuilder<HdrMethod>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer numberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numberOfSignificantValueDigits != null) {
            generator.writeKey("number_of_significant_value_digits");
            generator.write(this.numberOfSignificantValueDigits.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupHdrMethodDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numberOfSignificantValueDigits, JsonpDeserializer.integerDeserializer(), "number_of_significant_value_digits");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HdrMethod> {
        @Nullable
        private Integer numberOfSignificantValueDigits;

        public Builder() {
        }

        private Builder(HdrMethod instance) {
            this.numberOfSignificantValueDigits = instance.numberOfSignificantValueDigits;
        }

        public final Builder numberOfSignificantValueDigits(@Nullable Integer value) {
            this.numberOfSignificantValueDigits = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HdrMethod build() {
            this._checkSingleUse();
            return new HdrMethod(this);
        }
    }
}

