/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.DistanceUnit;
import co.elastic.clients.elasticsearch._types.GeoDistanceType;
import co.elastic.clients.elasticsearch._types.GeoLocation;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationRange;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoDistanceAggregation
extends BucketAggregationBase
implements AggregationVariant,
JsonpSerializable {
    @Nullable
    private final GeoDistanceType distanceType;
    @Nullable
    private final String field;
    @Nullable
    private final GeoLocation origin;
    private final List<AggregationRange> ranges;
    @Nullable
    private final DistanceUnit unit;
    public static final JsonpDeserializer<GeoDistanceAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoDistanceAggregation::setupGeoDistanceAggregationDeserializer);

    private GeoDistanceAggregation(Builder builder) {
        this.distanceType = builder.distanceType;
        this.field = builder.field;
        this.origin = builder.origin;
        this.ranges = ApiTypeHelper.unmodifiable(builder.ranges);
        this.unit = builder.unit;
    }

    public static GeoDistanceAggregation of(Function<Builder, ObjectBuilder<GeoDistanceAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeoDistance;
    }

    @Nullable
    public final GeoDistanceType distanceType() {
        return this.distanceType;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final GeoLocation origin() {
        return this.origin;
    }

    public final List<AggregationRange> ranges() {
        return this.ranges;
    }

    @Nullable
    public final DistanceUnit unit() {
        return this.unit;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.distanceType != null) {
            generator.writeKey("distance_type");
            this.distanceType.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.origin != null) {
            generator.writeKey("origin");
            this.origin.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.ranges)) {
            generator.writeKey("ranges");
            generator.writeStartArray();
            for (AggregationRange item0 : this.ranges) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.unit != null) {
            generator.writeKey("unit");
            this.unit.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGeoDistanceAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::distanceType, GeoDistanceType._DESERIALIZER, "distance_type");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::origin, GeoLocation._DESERIALIZER, "origin");
        op.add(Builder::ranges, JsonpDeserializer.arrayDeserializer(AggregationRange._DESERIALIZER), "ranges");
        op.add(Builder::unit, DistanceUnit._DESERIALIZER, "unit");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoDistanceAggregation> {
        @Nullable
        private GeoDistanceType distanceType;
        @Nullable
        private String field;
        @Nullable
        private GeoLocation origin;
        @Nullable
        private List<AggregationRange> ranges;
        @Nullable
        private DistanceUnit unit;

        public Builder() {
        }

        private Builder(GeoDistanceAggregation instance) {
            this.distanceType = instance.distanceType;
            this.field = instance.field;
            this.origin = instance.origin;
            this.ranges = instance.ranges;
            this.unit = instance.unit;
        }

        public final Builder distanceType(@Nullable GeoDistanceType value) {
            this.distanceType = value;
            return this;
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder origin(@Nullable GeoLocation value) {
            this.origin = value;
            return this;
        }

        public final Builder origin(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.origin(fn.apply(new GeoLocation.Builder()).build());
        }

        public final Builder ranges(List<AggregationRange> list) {
            this.ranges = Builder._listAddAll(this.ranges, list);
            return this;
        }

        public final Builder ranges(AggregationRange value, AggregationRange ... values) {
            this.ranges = Builder._listAdd(this.ranges, value, values);
            return this;
        }

        public final Builder ranges(Function<AggregationRange.Builder, ObjectBuilder<AggregationRange>> fn) {
            return this.ranges(fn.apply(new AggregationRange.Builder()).build(), new AggregationRange[0]);
        }

        public final Builder unit(@Nullable DistanceUnit value) {
            this.unit = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoDistanceAggregation build() {
            this._checkSingleUse();
            return new GeoDistanceAggregation(this);
        }
    }
}

