/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.FormatMetricAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExtendedStatsAggregation
extends FormatMetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Double sigma;
    public static final JsonpDeserializer<ExtendedStatsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExtendedStatsAggregation::setupExtendedStatsAggregationDeserializer);

    private ExtendedStatsAggregation(Builder builder) {
        super(builder);
        this.sigma = builder.sigma;
    }

    public static ExtendedStatsAggregation of(Function<Builder, ObjectBuilder<ExtendedStatsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.ExtendedStats;
    }

    @Nullable
    public final Double sigma() {
        return this.sigma;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.sigma != null) {
            generator.writeKey("sigma");
            generator.write(this.sigma.doubleValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupExtendedStatsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        FormatMetricAggregationBase.setupFormatMetricAggregationBaseDeserializer(op);
        op.add(Builder::sigma, JsonpDeserializer.doubleDeserializer(), "sigma");
    }

    public static class Builder
    extends FormatMetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ExtendedStatsAggregation> {
        @Nullable
        private Double sigma;

        public Builder() {
        }

        private Builder(ExtendedStatsAggregation instance) {
            this.sigma = instance.sigma;
        }

        public final Builder sigma(@Nullable Double value) {
            this.sigma = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExtendedStatsAggregation build() {
            this._checkSingleUse();
            return new ExtendedStatsAggregation(this);
        }
    }
}

