/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ChangePointBucket
extends MultiBucketBase {
    private final FieldValue key;
    public static final JsonpDeserializer<ChangePointBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChangePointBucket::setupChangePointBucketDeserializer);

    private ChangePointBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
    }

    public static ChangePointBucket of(Function<Builder, ObjectBuilder<ChangePointBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final FieldValue key() {
        return this.key;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("key");
        this.key.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupChangePointBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::key, FieldValue._DESERIALIZER, "key");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ChangePointBucket> {
        private FieldValue key;

        public Builder() {
        }

        private Builder(ChangePointBucket instance) {
            this.key = instance.key;
        }

        public final Builder key(FieldValue value) {
            this.key = value;
            return this;
        }

        public final Builder key(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.key(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder key(String value) {
            this.key = FieldValue.of(value);
            return this;
        }

        public final Builder key(long value) {
            this.key = FieldValue.of(value);
            return this;
        }

        public final Builder key(double value) {
            this.key = FieldValue.of(value);
            return this;
        }

        public final Builder key(boolean value) {
            this.key = FieldValue.of(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ChangePointBucket build() {
            this._checkSingleUse();
            return new ChangePointBucket(this);
        }
    }
}

