/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.MetricAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.TDigestExecutionHint;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BoxplotAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Double compression;
    @Nullable
    private final TDigestExecutionHint executionHint;
    public static final JsonpDeserializer<BoxplotAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BoxplotAggregation::setupBoxplotAggregationDeserializer);

    private BoxplotAggregation(Builder builder) {
        super(builder);
        this.compression = builder.compression;
        this.executionHint = builder.executionHint;
    }

    public static BoxplotAggregation of(Function<Builder, ObjectBuilder<BoxplotAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Boxplot;
    }

    @Nullable
    public final Double compression() {
        return this.compression;
    }

    @Nullable
    public final TDigestExecutionHint executionHint() {
        return this.executionHint;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.compression != null) {
            generator.writeKey("compression");
            generator.write(this.compression.doubleValue());
        }
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupBoxplotAggregationDeserializer(ObjectDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::compression, JsonpDeserializer.doubleDeserializer(), "compression");
        op.add(Builder::executionHint, TDigestExecutionHint._DESERIALIZER, "execution_hint");
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BoxplotAggregation> {
        @Nullable
        private Double compression;
        @Nullable
        private TDigestExecutionHint executionHint;

        public Builder() {
        }

        private Builder(BoxplotAggregation instance) {
            this.compression = instance.compression;
            this.executionHint = instance.executionHint;
        }

        public final Builder compression(@Nullable Double value) {
            this.compression = value;
            return this;
        }

        public final Builder executionHint(@Nullable TDigestExecutionHint value) {
            this.executionHint = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BoxplotAggregation build() {
            this._checkSingleUse();
            return new BoxplotAggregation(this);
        }
    }
}

