/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RRFRetrieverComponent
implements JsonpSerializable {
    private final Retriever retriever;
    @Nullable
    private final Float weight;
    public static final JsonpDeserializer<RRFRetrieverComponent> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RRFRetrieverComponent::setupRRFRetrieverComponentDeserializer);

    private RRFRetrieverComponent(Builder builder) {
        this.retriever = ApiTypeHelper.requireNonNull(builder.retriever, this, "retriever");
        this.weight = builder.weight;
    }

    public static RRFRetrieverComponent of(Function<Builder, ObjectBuilder<RRFRetrieverComponent>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Retriever retriever() {
        return this.retriever;
    }

    @Nullable
    public final Float weight() {
        return this.weight;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("retriever");
        this.retriever.serialize(generator, mapper);
        if (this.weight != null) {
            generator.writeKey("weight");
            generator.write((double)this.weight.floatValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRRFRetrieverComponentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::retriever, Retriever._DESERIALIZER, "retriever");
        op.add(Builder::weight, JsonpDeserializer.floatDeserializer(), "weight");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RRFRetrieverComponent> {
        private Retriever retriever;
        @Nullable
        private Float weight;

        public Builder() {
        }

        private Builder(RRFRetrieverComponent instance) {
            this.retriever = instance.retriever;
            this.weight = instance.weight;
        }

        public final Builder retriever(Retriever value) {
            this.retriever = value;
            return this;
        }

        public final Builder retriever(Function<Retriever.Builder, ObjectBuilder<Retriever>> fn) {
            return this.retriever(fn.apply(new Retriever.Builder()).build());
        }

        public final Builder retriever(RetrieverVariant value) {
            this.retriever = value._toRetriever();
            return this;
        }

        public final Builder weight(@Nullable Float value) {
            this.weight = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RRFRetrieverComponent build() {
            this._checkSingleUse();
            return new RRFRetrieverComponent(this);
        }
    }
}

