/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.QueryVectorBuilder;
import co.elastic.clients.elasticsearch._types.QueryVectorBuilderVariant;
import co.elastic.clients.elasticsearch._types.RescoreVector;
import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverBase;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KnnRetriever
extends RetrieverBase
implements RetrieverVariant {
    private final String field;
    private final List<Float> queryVector;
    @Nullable
    private final QueryVectorBuilder queryVectorBuilder;
    private final int k;
    private final int numCandidates;
    @Nullable
    private final Float visitPercentage;
    @Nullable
    private final Float similarity;
    @Nullable
    private final RescoreVector rescoreVector;
    public static final JsonpDeserializer<KnnRetriever> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnRetriever::setupKnnRetrieverDeserializer);

    private KnnRetriever(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.queryVector = ApiTypeHelper.unmodifiable(builder.queryVector);
        this.queryVectorBuilder = builder.queryVectorBuilder;
        this.k = ApiTypeHelper.requireNonNull(builder.k, (Object)this, "k", 0);
        this.numCandidates = ApiTypeHelper.requireNonNull(builder.numCandidates, (Object)this, "numCandidates", 0);
        this.visitPercentage = builder.visitPercentage;
        this.similarity = builder.similarity;
        this.rescoreVector = builder.rescoreVector;
    }

    public static KnnRetriever of(Function<Builder, ObjectBuilder<KnnRetriever>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Retriever.Kind _retrieverKind() {
        return Retriever.Kind.Knn;
    }

    public final String field() {
        return this.field;
    }

    public final List<Float> queryVector() {
        return this.queryVector;
    }

    @Nullable
    public final QueryVectorBuilder queryVectorBuilder() {
        return this.queryVectorBuilder;
    }

    public final int k() {
        return this.k;
    }

    public final int numCandidates() {
        return this.numCandidates;
    }

    @Nullable
    public final Float visitPercentage() {
        return this.visitPercentage;
    }

    @Nullable
    public final Float similarity() {
        return this.similarity;
    }

    @Nullable
    public final RescoreVector rescoreVector() {
        return this.rescoreVector;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.queryVector)) {
            generator.writeKey("query_vector");
            generator.writeStartArray();
            for (Float item0 : this.queryVector) {
                generator.write((double)item0.floatValue());
            }
            generator.writeEnd();
        }
        if (this.queryVectorBuilder != null) {
            generator.writeKey("query_vector_builder");
            this.queryVectorBuilder.serialize(generator, mapper);
        }
        generator.writeKey("k");
        generator.write(this.k);
        generator.writeKey("num_candidates");
        generator.write(this.numCandidates);
        if (this.visitPercentage != null) {
            generator.writeKey("visit_percentage");
            generator.write((double)this.visitPercentage.floatValue());
        }
        if (this.similarity != null) {
            generator.writeKey("similarity");
            generator.write((double)this.similarity.floatValue());
        }
        if (this.rescoreVector != null) {
            generator.writeKey("rescore_vector");
            this.rescoreVector.serialize(generator, mapper);
        }
    }

    protected static void setupKnnRetrieverDeserializer(ObjectDeserializer<Builder> op) {
        RetrieverBase.setupRetrieverBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::queryVector, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.floatDeserializer()), "query_vector");
        op.add(Builder::queryVectorBuilder, QueryVectorBuilder._DESERIALIZER, "query_vector_builder");
        op.add(Builder::k, JsonpDeserializer.integerDeserializer(), "k");
        op.add(Builder::numCandidates, JsonpDeserializer.integerDeserializer(), "num_candidates");
        op.add(Builder::visitPercentage, JsonpDeserializer.floatDeserializer(), "visit_percentage");
        op.add(Builder::similarity, JsonpDeserializer.floatDeserializer(), "similarity");
        op.add(Builder::rescoreVector, RescoreVector._DESERIALIZER, "rescore_vector");
    }

    public static class Builder
    extends RetrieverBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KnnRetriever> {
        private String field;
        @Nullable
        private List<Float> queryVector;
        @Nullable
        private QueryVectorBuilder queryVectorBuilder;
        private Integer k;
        private Integer numCandidates;
        @Nullable
        private Float visitPercentage;
        @Nullable
        private Float similarity;
        @Nullable
        private RescoreVector rescoreVector;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder queryVector(List<Float> list) {
            this.queryVector = Builder._listAddAll(this.queryVector, list);
            return this;
        }

        public final Builder queryVector(Float value, Float ... values) {
            this.queryVector = Builder._listAdd(this.queryVector, value, values);
            return this;
        }

        public final Builder queryVectorBuilder(@Nullable QueryVectorBuilder value) {
            this.queryVectorBuilder = value;
            return this;
        }

        public final Builder queryVectorBuilder(Function<QueryVectorBuilder.Builder, ObjectBuilder<QueryVectorBuilder>> fn) {
            return this.queryVectorBuilder(fn.apply(new QueryVectorBuilder.Builder()).build());
        }

        public final Builder queryVectorBuilder(QueryVectorBuilderVariant value) {
            this.queryVectorBuilder = value._toQueryVectorBuilder();
            return this;
        }

        public final Builder k(int value) {
            this.k = value;
            return this;
        }

        public final Builder numCandidates(int value) {
            this.numCandidates = value;
            return this;
        }

        public final Builder visitPercentage(@Nullable Float value) {
            this.visitPercentage = value;
            return this;
        }

        public final Builder similarity(@Nullable Float value) {
            this.similarity = value;
            return this;
        }

        public final Builder rescoreVector(@Nullable RescoreVector value) {
            this.rescoreVector = value;
            return this;
        }

        public final Builder rescoreVector(Function<RescoreVector.Builder, ObjectBuilder<RescoreVector>> fn) {
            return this.rescoreVector(fn.apply(new RescoreVector.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KnnRetriever build() {
            this._checkSingleUse();
            return new KnnRetriever(this);
        }
    }
}

