/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Processor
implements JsonpSerializable {
    @Nullable
    private final Long count;
    @Nullable
    private final Long current;
    @Nullable
    private final Long failed;
    @Nullable
    private final Long timeInMillis;
    public static final JsonpDeserializer<Processor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Processor::setupProcessorDeserializer);

    private Processor(Builder builder) {
        this.count = builder.count;
        this.current = builder.current;
        this.failed = builder.failed;
        this.timeInMillis = builder.timeInMillis;
    }

    public static Processor of(Function<Builder, ObjectBuilder<Processor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long count() {
        return this.count;
    }

    @Nullable
    public final Long current() {
        return this.current;
    }

    @Nullable
    public final Long failed() {
        return this.failed;
    }

    @Nullable
    public final Long timeInMillis() {
        return this.timeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count.longValue());
        }
        if (this.current != null) {
            generator.writeKey("current");
            generator.write(this.current.longValue());
        }
        if (this.failed != null) {
            generator.writeKey("failed");
            generator.write(this.failed.longValue());
        }
        if (this.timeInMillis != null) {
            generator.writeKey("time_in_millis");
            generator.write(this.timeInMillis.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current");
        op.add(Builder::failed, JsonpDeserializer.longDeserializer(), "failed");
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Processor> {
        @Nullable
        private Long count;
        @Nullable
        private Long current;
        @Nullable
        private Long failed;
        @Nullable
        private Long timeInMillis;

        public final Builder count(@Nullable Long value) {
            this.count = value;
            return this;
        }

        public final Builder current(@Nullable Long value) {
            this.current = value;
            return this;
        }

        public final Builder failed(@Nullable Long value) {
            this.failed = value;
            return this;
        }

        public final Builder timeInMillis(@Nullable Long value) {
            this.timeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Processor build() {
            this._checkSingleUse();
            return new Processor(this);
        }
    }
}

