/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetJobsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetJobsRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean excludeGenerated;
    private final List<String> jobId;
    public static final Endpoint<GetJobsRequest, GetJobsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetJobsRequest, GetJobsResponse>("es/ml.get_jobs", request -> "GET", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.jobId())) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.excludeGenerated != null) {
            params.put("exclude_generated", String.valueOf(request.excludeGenerated));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetJobsResponse._DESERIALIZER);

    private GetJobsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.excludeGenerated = builder.excludeGenerated;
        this.jobId = ApiTypeHelper.unmodifiable(builder.jobId);
    }

    public static GetJobsRequest of(Function<Builder, ObjectBuilder<GetJobsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Boolean excludeGenerated() {
        return this.excludeGenerated;
    }

    public final List<String> jobId() {
        return this.jobId;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetJobsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean excludeGenerated;
        @Nullable
        private List<String> jobId;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder excludeGenerated(@Nullable Boolean value) {
            this.excludeGenerated = value;
            return this;
        }

        public final Builder jobId(List<String> list) {
            this.jobId = Builder._listAddAll(this.jobId, list);
            return this;
        }

        public final Builder jobId(String value, String ... values) {
            this.jobId = Builder._listAdd(this.jobId, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetJobsRequest build() {
            this._checkSingleUse();
            return new GetJobsRequest(this);
        }
    }
}

