/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class EnrollNodeResponse
implements JsonpSerializable {
    private final String httpCaKey;
    private final String httpCaCert;
    private final String transportCaCert;
    private final String transportKey;
    private final String transportCert;
    private final List<String> nodesAddresses;
    public static final JsonpDeserializer<EnrollNodeResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EnrollNodeResponse::setupEnrollNodeResponseDeserializer);

    private EnrollNodeResponse(Builder builder) {
        this.httpCaKey = ApiTypeHelper.requireNonNull(builder.httpCaKey, this, "httpCaKey");
        this.httpCaCert = ApiTypeHelper.requireNonNull(builder.httpCaCert, this, "httpCaCert");
        this.transportCaCert = ApiTypeHelper.requireNonNull(builder.transportCaCert, this, "transportCaCert");
        this.transportKey = ApiTypeHelper.requireNonNull(builder.transportKey, this, "transportKey");
        this.transportCert = ApiTypeHelper.requireNonNull(builder.transportCert, this, "transportCert");
        this.nodesAddresses = ApiTypeHelper.unmodifiableRequired(builder.nodesAddresses, (Object)this, "nodesAddresses");
    }

    public static EnrollNodeResponse of(Function<Builder, ObjectBuilder<EnrollNodeResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String httpCaKey() {
        return this.httpCaKey;
    }

    public final String httpCaCert() {
        return this.httpCaCert;
    }

    public final String transportCaCert() {
        return this.transportCaCert;
    }

    public final String transportKey() {
        return this.transportKey;
    }

    public final String transportCert() {
        return this.transportCert;
    }

    public final List<String> nodesAddresses() {
        return this.nodesAddresses;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("http_ca_key");
        generator.write(this.httpCaKey);
        generator.writeKey("http_ca_cert");
        generator.write(this.httpCaCert);
        generator.writeKey("transport_ca_cert");
        generator.write(this.transportCaCert);
        generator.writeKey("transport_key");
        generator.write(this.transportKey);
        generator.writeKey("transport_cert");
        generator.write(this.transportCert);
        if (ApiTypeHelper.isDefined(this.nodesAddresses)) {
            generator.writeKey("nodes_addresses");
            generator.writeStartArray();
            for (String item0 : this.nodesAddresses) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupEnrollNodeResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::httpCaKey, JsonpDeserializer.stringDeserializer(), "http_ca_key");
        op.add(Builder::httpCaCert, JsonpDeserializer.stringDeserializer(), "http_ca_cert");
        op.add(Builder::transportCaCert, JsonpDeserializer.stringDeserializer(), "transport_ca_cert");
        op.add(Builder::transportKey, JsonpDeserializer.stringDeserializer(), "transport_key");
        op.add(Builder::transportCert, JsonpDeserializer.stringDeserializer(), "transport_cert");
        op.add(Builder::nodesAddresses, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "nodes_addresses");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<EnrollNodeResponse> {
        private String httpCaKey;
        private String httpCaCert;
        private String transportCaCert;
        private String transportKey;
        private String transportCert;
        private List<String> nodesAddresses;

        public final Builder httpCaKey(String value) {
            this.httpCaKey = value;
            return this;
        }

        public final Builder httpCaCert(String value) {
            this.httpCaCert = value;
            return this;
        }

        public final Builder transportCaCert(String value) {
            this.transportCaCert = value;
            return this;
        }

        public final Builder transportKey(String value) {
            this.transportKey = value;
            return this;
        }

        public final Builder transportCert(String value) {
            this.transportCert = value;
            return this;
        }

        public final Builder nodesAddresses(List<String> list) {
            this.nodesAddresses = Builder._listAddAll(this.nodesAddresses, list);
            return this;
        }

        public final Builder nodesAddresses(String value, String ... values) {
            this.nodesAddresses = Builder._listAdd(this.nodesAddresses, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EnrollNodeResponse build() {
            this._checkSingleUse();
            return new EnrollNodeResponse(this);
        }
    }
}

