/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.DeleteServiceTokenResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DeleteServiceTokenRequest
extends RequestBase {
    private final String name;
    private final String namespace;
    @Nullable
    private final Refresh refresh;
    private final String service;
    public static final Endpoint<DeleteServiceTokenRequest, DeleteServiceTokenResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteServiceTokenRequest, DeleteServiceTokenResponse>("es/security.delete_service_token", request -> "DELETE", request -> {
        boolean _service = true;
        int _namespace = 2;
        int _name = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if ((propsSet |= 4) == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.service, buf);
            buf.append("/credential");
            buf.append("/token");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteServiceTokenResponse._DESERIALIZER);

    private DeleteServiceTokenRequest(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.namespace = ApiTypeHelper.requireNonNull(builder.namespace, this, "namespace");
        this.refresh = builder.refresh;
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
    }

    public static DeleteServiceTokenRequest of(Function<Builder, ObjectBuilder<DeleteServiceTokenRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final String namespace() {
        return this.namespace;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    public final String service() {
        return this.service;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteServiceTokenRequest> {
        private String name;
        private String namespace;
        @Nullable
        private Refresh refresh;
        private String service;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder service(String value) {
            this.service = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteServiceTokenRequest build() {
            this._checkSingleUse();
            return new DeleteServiceTokenRequest(this);
        }
    }
}

