/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ilm.MigrateToDataTiersResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MigrateToDataTiersRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean dryRun;
    @Nullable
    private final String legacyTemplateToDelete;
    @Nullable
    private final String nodeAttribute;
    public static final JsonpDeserializer<MigrateToDataTiersRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MigrateToDataTiersRequest::setupMigrateToDataTiersRequestDeserializer);
    public static final Endpoint<MigrateToDataTiersRequest, MigrateToDataTiersResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MigrateToDataTiersRequest, MigrateToDataTiersResponse>("es/ilm.migrate_to_data_tiers", request -> "POST", request -> "/_ilm/migrate_to_data_tiers", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.dryRun != null) {
            params.put("dry_run", String.valueOf(request.dryRun));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, MigrateToDataTiersResponse._DESERIALIZER);

    private MigrateToDataTiersRequest(Builder builder) {
        this.dryRun = builder.dryRun;
        this.legacyTemplateToDelete = builder.legacyTemplateToDelete;
        this.nodeAttribute = builder.nodeAttribute;
    }

    public static MigrateToDataTiersRequest of(Function<Builder, ObjectBuilder<MigrateToDataTiersRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Nullable
    public final String legacyTemplateToDelete() {
        return this.legacyTemplateToDelete;
    }

    @Nullable
    public final String nodeAttribute() {
        return this.nodeAttribute;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.legacyTemplateToDelete != null) {
            generator.writeKey("legacy_template_to_delete");
            generator.write(this.legacyTemplateToDelete);
        }
        if (this.nodeAttribute != null) {
            generator.writeKey("node_attribute");
            generator.write(this.nodeAttribute);
        }
    }

    protected static void setupMigrateToDataTiersRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::legacyTemplateToDelete, JsonpDeserializer.stringDeserializer(), "legacy_template_to_delete");
        op.add(Builder::nodeAttribute, JsonpDeserializer.stringDeserializer(), "node_attribute");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MigrateToDataTiersRequest> {
        @Nullable
        private Boolean dryRun;
        @Nullable
        private String legacyTemplateToDelete;
        @Nullable
        private String nodeAttribute;

        public final Builder dryRun(@Nullable Boolean value) {
            this.dryRun = value;
            return this;
        }

        public final Builder legacyTemplateToDelete(@Nullable String value) {
            this.legacyTemplateToDelete = value;
            return this;
        }

        public final Builder nodeAttribute(@Nullable String value) {
            this.nodeAttribute = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MigrateToDataTiersRequest build() {
            this._checkSingleUse();
            return new MigrateToDataTiersRequest(this);
        }
    }
}

