/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.msearch;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.KnnQuery;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.FieldAndFormat;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.FieldCollapse;
import co.elastic.clients.elasticsearch.core.search.Highlight;
import co.elastic.clients.elasticsearch.core.search.PointInTimeReference;
import co.elastic.clients.elasticsearch.core.search.Rescore;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.elasticsearch.core.search.Suggester;
import co.elastic.clients.elasticsearch.core.search.TrackHits;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MultisearchBody
implements JsonpSerializable {
    private final Map<String, Aggregation> aggregations;
    @Nullable
    private final FieldCollapse collapse;
    @Nullable
    private final Query query;
    @Nullable
    private final Boolean explain;
    private final Map<String, JsonData> ext;
    private final List<String> storedFields;
    private final List<FieldAndFormat> docvalueFields;
    @Nullable
    private final KnnQuery knn;
    @Nullable
    private final Integer from;
    @Nullable
    private final Highlight highlight;
    private final List<Map<String, Double>> indicesBoost;
    @Nullable
    private final Double minScore;
    @Nullable
    private final Query postFilter;
    @Nullable
    private final Boolean profile;
    private final List<Rescore> rescore;
    private final Map<String, ScriptField> scriptFields;
    private final List<FieldValue> searchAfter;
    @Nullable
    private final Integer size;
    private final List<SortOptions> sort;
    @Nullable
    private final SourceConfig source;
    private final List<FieldAndFormat> fields;
    @Nullable
    private final Long terminateAfter;
    private final List<String> stats;
    @Nullable
    private final String timeout;
    @Nullable
    private final Boolean trackScores;
    @Nullable
    private final TrackHits trackTotalHits;
    @Nullable
    private final Boolean version;
    private final Map<String, RuntimeField> runtimeMappings;
    @Nullable
    private final Boolean seqNoPrimaryTerm;
    @Nullable
    private final PointInTimeReference pit;
    @Nullable
    private final Suggester suggest;
    public static final JsonpDeserializer<MultisearchBody> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultisearchBody::setupMultisearchBodyDeserializer);

    private MultisearchBody(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.collapse = builder.collapse;
        this.query = builder.query;
        this.explain = builder.explain;
        this.ext = ApiTypeHelper.unmodifiable(builder.ext);
        this.storedFields = ApiTypeHelper.unmodifiable(builder.storedFields);
        this.docvalueFields = ApiTypeHelper.unmodifiable(builder.docvalueFields);
        this.knn = builder.knn;
        this.from = builder.from;
        this.highlight = builder.highlight;
        this.indicesBoost = ApiTypeHelper.unmodifiable(builder.indicesBoost);
        this.minScore = builder.minScore;
        this.postFilter = builder.postFilter;
        this.profile = builder.profile;
        this.rescore = ApiTypeHelper.unmodifiable(builder.rescore);
        this.scriptFields = ApiTypeHelper.unmodifiable(builder.scriptFields);
        this.searchAfter = ApiTypeHelper.unmodifiable(builder.searchAfter);
        this.size = builder.size;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
        this.source = builder.source;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.terminateAfter = builder.terminateAfter;
        this.stats = ApiTypeHelper.unmodifiable(builder.stats);
        this.timeout = builder.timeout;
        this.trackScores = builder.trackScores;
        this.trackTotalHits = builder.trackTotalHits;
        this.version = builder.version;
        this.runtimeMappings = ApiTypeHelper.unmodifiable(builder.runtimeMappings);
        this.seqNoPrimaryTerm = builder.seqNoPrimaryTerm;
        this.pit = builder.pit;
        this.suggest = builder.suggest;
    }

    public static MultisearchBody of(Function<Builder, ObjectBuilder<MultisearchBody>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final FieldCollapse collapse() {
        return this.collapse;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Boolean explain() {
        return this.explain;
    }

    public final Map<String, JsonData> ext() {
        return this.ext;
    }

    public final List<String> storedFields() {
        return this.storedFields;
    }

    public final List<FieldAndFormat> docvalueFields() {
        return this.docvalueFields;
    }

    @Nullable
    public final KnnQuery knn() {
        return this.knn;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Highlight highlight() {
        return this.highlight;
    }

    public final List<Map<String, Double>> indicesBoost() {
        return this.indicesBoost;
    }

    @Nullable
    public final Double minScore() {
        return this.minScore;
    }

    @Nullable
    public final Query postFilter() {
        return this.postFilter;
    }

    @Nullable
    public final Boolean profile() {
        return this.profile;
    }

    public final List<Rescore> rescore() {
        return this.rescore;
    }

    public final Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    public final List<FieldValue> searchAfter() {
        return this.searchAfter;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public final List<SortOptions> sort() {
        return this.sort;
    }

    @Nullable
    public final SourceConfig source() {
        return this.source;
    }

    public final List<FieldAndFormat> fields() {
        return this.fields;
    }

    @Nullable
    public final Long terminateAfter() {
        return this.terminateAfter;
    }

    public final List<String> stats() {
        return this.stats;
    }

    @Nullable
    public final String timeout() {
        return this.timeout;
    }

    @Nullable
    public final Boolean trackScores() {
        return this.trackScores;
    }

    @Nullable
    public final TrackHits trackTotalHits() {
        return this.trackTotalHits;
    }

    @Nullable
    public final Boolean version() {
        return this.version;
    }

    public final Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Nullable
    public final Boolean seqNoPrimaryTerm() {
        return this.seqNoPrimaryTerm;
    }

    @Nullable
    public final PointInTimeReference pit() {
        return this.pit;
    }

    @Nullable
    public final Suggester suggest() {
        return this.suggest;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.collapse != null) {
            generator.writeKey("collapse");
            this.collapse.serialize(generator, mapper);
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.ext)) {
            generator.writeKey("ext");
            generator.writeStartObject();
            for (Map.Entry entry : this.ext.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.storedFields)) {
            generator.writeKey("stored_fields");
            generator.writeStartArray();
            for (String string : this.storedFields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.docvalueFields)) {
            generator.writeKey("docvalue_fields");
            generator.writeStartArray();
            for (FieldAndFormat fieldAndFormat : this.docvalueFields) {
                fieldAndFormat.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.knn != null) {
            generator.writeKey("knn");
            this.knn.serialize(generator, mapper);
        }
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.highlight != null) {
            generator.writeKey("highlight");
            this.highlight.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.indicesBoost)) {
            generator.writeKey("indices_boost");
            generator.writeStartArray();
            for (Map map : this.indicesBoost) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry item1 : map.entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        generator.write(((Double)item1.getValue()).doubleValue());
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write(this.minScore.doubleValue());
        }
        if (this.postFilter != null) {
            generator.writeKey("post_filter");
            this.postFilter.serialize(generator, mapper);
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            generator.write(this.profile.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.rescore)) {
            generator.writeKey("rescore");
            generator.writeStartArray();
            for (Rescore rescore : this.rescore) {
                rescore.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.scriptFields)) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.searchAfter)) {
            generator.writeKey("search_after");
            generator.writeStartArray();
            for (FieldValue fieldValue : this.searchAfter) {
                fieldValue.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (SortOptions sortOptions : this.sort) {
                sortOptions.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (FieldAndFormat fieldAndFormat : this.fields) {
                fieldAndFormat.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.terminateAfter != null) {
            generator.writeKey("terminate_after");
            generator.write(this.terminateAfter.longValue());
        }
        if (ApiTypeHelper.isDefined(this.stats)) {
            generator.writeKey("stats");
            generator.writeStartArray();
            for (String string : this.stats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            generator.write(this.timeout);
        }
        if (this.trackScores != null) {
            generator.writeKey("track_scores");
            generator.write(this.trackScores.booleanValue());
        }
        if (this.trackTotalHits != null) {
            generator.writeKey("track_total_hits");
            this.trackTotalHits.serialize(generator, mapper);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.runtimeMappings)) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.seqNoPrimaryTerm != null) {
            generator.writeKey("seq_no_primary_term");
            generator.write(this.seqNoPrimaryTerm.booleanValue());
        }
        if (this.pit != null) {
            generator.writeKey("pit");
            this.pit.serialize(generator, mapper);
        }
        if (this.suggest != null) {
            generator.writeKey("suggest");
            this.suggest.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupMultisearchBodyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", "aggs");
        op.add(Builder::collapse, FieldCollapse._DESERIALIZER, "collapse");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain");
        op.add(Builder::ext, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "ext");
        op.add(Builder::storedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stored_fields");
        op.add(Builder::docvalueFields, JsonpDeserializer.arrayDeserializer(FieldAndFormat._DESERIALIZER), "docvalue_fields");
        op.add(Builder::knn, KnnQuery._DESERIALIZER, "knn");
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from");
        op.add(Builder::highlight, Highlight._DESERIALIZER, "highlight");
        op.add(Builder::indicesBoost, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer())), "indices_boost");
        op.add(Builder::minScore, JsonpDeserializer.doubleDeserializer(), "min_score");
        op.add(Builder::postFilter, Query._DESERIALIZER, "post_filter");
        op.add(Builder::profile, JsonpDeserializer.booleanDeserializer(), "profile");
        op.add(Builder::rescore, JsonpDeserializer.arrayDeserializer(Rescore._DESERIALIZER), "rescore");
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields");
        op.add(Builder::searchAfter, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "search_after");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(SortOptions._DESERIALIZER), "sort");
        op.add(Builder::source, SourceConfig._DESERIALIZER, "_source");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(FieldAndFormat._DESERIALIZER), "fields");
        op.add(Builder::terminateAfter, JsonpDeserializer.longDeserializer(), "terminate_after");
        op.add(Builder::stats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stats");
        op.add(Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout");
        op.add(Builder::trackScores, JsonpDeserializer.booleanDeserializer(), "track_scores");
        op.add(Builder::trackTotalHits, TrackHits._DESERIALIZER, "track_total_hits");
        op.add(Builder::version, JsonpDeserializer.booleanDeserializer(), "version");
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings");
        op.add(Builder::seqNoPrimaryTerm, JsonpDeserializer.booleanDeserializer(), "seq_no_primary_term");
        op.add(Builder::pit, PointInTimeReference._DESERIALIZER, "pit");
        op.add(Builder::suggest, Suggester._DESERIALIZER, "suggest");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MultisearchBody> {
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private FieldCollapse collapse;
        @Nullable
        private Query query;
        @Nullable
        private Boolean explain;
        @Nullable
        private Map<String, JsonData> ext;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private List<FieldAndFormat> docvalueFields;
        @Nullable
        private KnnQuery knn;
        @Nullable
        private Integer from;
        @Nullable
        private Highlight highlight;
        @Nullable
        private List<Map<String, Double>> indicesBoost;
        @Nullable
        private Double minScore;
        @Nullable
        private Query postFilter;
        @Nullable
        private Boolean profile;
        @Nullable
        private List<Rescore> rescore;
        @Nullable
        private Map<String, ScriptField> scriptFields;
        @Nullable
        private List<FieldValue> searchAfter;
        @Nullable
        private Integer size;
        @Nullable
        private List<SortOptions> sort;
        @Nullable
        private SourceConfig source;
        @Nullable
        private List<FieldAndFormat> fields;
        @Nullable
        private Long terminateAfter;
        @Nullable
        private List<String> stats;
        @Nullable
        private String timeout;
        @Nullable
        private Boolean trackScores;
        @Nullable
        private TrackHits trackTotalHits;
        @Nullable
        private Boolean version;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private Boolean seqNoPrimaryTerm;
        @Nullable
        private PointInTimeReference pit;
        @Nullable
        private Suggester suggest;

        public final Builder aggregations(Map<String, Aggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, Aggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public final Builder collapse(@Nullable FieldCollapse value) {
            this.collapse = value;
            return this;
        }

        public final Builder collapse(Function<FieldCollapse.Builder, ObjectBuilder<FieldCollapse>> fn) {
            return this.collapse(fn.apply(new FieldCollapse.Builder()).build());
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public final Builder ext(Map<String, JsonData> map) {
            this.ext = Builder._mapPutAll(this.ext, map);
            return this;
        }

        public final Builder ext(String key, JsonData value) {
            this.ext = Builder._mapPut(this.ext, key, value);
            return this;
        }

        public final Builder storedFields(List<String> list) {
            this.storedFields = Builder._listAddAll(this.storedFields, list);
            return this;
        }

        public final Builder storedFields(String value, String ... values) {
            this.storedFields = Builder._listAdd(this.storedFields, value, values);
            return this;
        }

        public final Builder docvalueFields(List<FieldAndFormat> list) {
            this.docvalueFields = Builder._listAddAll(this.docvalueFields, list);
            return this;
        }

        public final Builder docvalueFields(FieldAndFormat value, FieldAndFormat ... values) {
            this.docvalueFields = Builder._listAdd(this.docvalueFields, value, values);
            return this;
        }

        public final Builder docvalueFields(Function<FieldAndFormat.Builder, ObjectBuilder<FieldAndFormat>> fn) {
            return this.docvalueFields(fn.apply(new FieldAndFormat.Builder()).build(), new FieldAndFormat[0]);
        }

        public final Builder knn(@Nullable KnnQuery value) {
            this.knn = value;
            return this;
        }

        public final Builder knn(Function<KnnQuery.Builder, ObjectBuilder<KnnQuery>> fn) {
            return this.knn(fn.apply(new KnnQuery.Builder()).build());
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder highlight(@Nullable Highlight value) {
            this.highlight = value;
            return this;
        }

        public final Builder highlight(Function<Highlight.Builder, ObjectBuilder<Highlight>> fn) {
            return this.highlight(fn.apply(new Highlight.Builder()).build());
        }

        public final Builder indicesBoost(List<Map<String, Double>> list) {
            this.indicesBoost = Builder._listAddAll(this.indicesBoost, list);
            return this;
        }

        public final Builder indicesBoost(Map<String, Double> value, Map<String, Double> ... values) {
            this.indicesBoost = Builder._listAdd(this.indicesBoost, value, values);
            return this;
        }

        public final Builder minScore(@Nullable Double value) {
            this.minScore = value;
            return this;
        }

        public final Builder postFilter(@Nullable Query value) {
            this.postFilter = value;
            return this;
        }

        public final Builder postFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.postFilter(fn.apply(new Query.Builder()).build());
        }

        public final Builder profile(@Nullable Boolean value) {
            this.profile = value;
            return this;
        }

        public final Builder rescore(List<Rescore> list) {
            this.rescore = Builder._listAddAll(this.rescore, list);
            return this;
        }

        public final Builder rescore(Rescore value, Rescore ... values) {
            this.rescore = Builder._listAdd(this.rescore, value, values);
            return this;
        }

        public final Builder rescore(Function<Rescore.Builder, ObjectBuilder<Rescore>> fn) {
            return this.rescore(fn.apply(new Rescore.Builder()).build(), new Rescore[0]);
        }

        public final Builder scriptFields(Map<String, ScriptField> map) {
            this.scriptFields = Builder._mapPutAll(this.scriptFields, map);
            return this;
        }

        public final Builder scriptFields(String key, ScriptField value) {
            this.scriptFields = Builder._mapPut(this.scriptFields, key, value);
            return this;
        }

        public final Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public final Builder searchAfter(List<FieldValue> list) {
            this.searchAfter = Builder._listAddAll(this.searchAfter, list);
            return this;
        }

        public final Builder searchAfter(FieldValue value, FieldValue ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, value, values);
            return this;
        }

        public final Builder searchAfter(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.searchAfter(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder sort(List<SortOptions> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(SortOptions value, SortOptions ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
            return this.sort(fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        }

        public final Builder source(@Nullable SourceConfig value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceConfig.Builder, ObjectBuilder<SourceConfig>> fn) {
            return this.source(fn.apply(new SourceConfig.Builder()).build());
        }

        public final Builder fields(List<FieldAndFormat> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(FieldAndFormat value, FieldAndFormat ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder fields(Function<FieldAndFormat.Builder, ObjectBuilder<FieldAndFormat>> fn) {
            return this.fields(fn.apply(new FieldAndFormat.Builder()).build(), new FieldAndFormat[0]);
        }

        public final Builder terminateAfter(@Nullable Long value) {
            this.terminateAfter = value;
            return this;
        }

        public final Builder stats(List<String> list) {
            this.stats = Builder._listAddAll(this.stats, list);
            return this;
        }

        public final Builder stats(String value, String ... values) {
            this.stats = Builder._listAdd(this.stats, value, values);
            return this;
        }

        public final Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public final Builder trackScores(@Nullable Boolean value) {
            this.trackScores = value;
            return this;
        }

        public final Builder trackTotalHits(@Nullable TrackHits value) {
            this.trackTotalHits = value;
            return this;
        }

        public final Builder trackTotalHits(Function<TrackHits.Builder, ObjectBuilder<TrackHits>> fn) {
            return this.trackTotalHits(fn.apply(new TrackHits.Builder()).build());
        }

        public final Builder version(@Nullable Boolean value) {
            this.version = value;
            return this;
        }

        public final Builder runtimeMappings(Map<String, RuntimeField> map) {
            this.runtimeMappings = Builder._mapPutAll(this.runtimeMappings, map);
            return this;
        }

        public final Builder runtimeMappings(String key, RuntimeField value) {
            this.runtimeMappings = Builder._mapPut(this.runtimeMappings, key, value);
            return this;
        }

        public final Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public final Builder seqNoPrimaryTerm(@Nullable Boolean value) {
            this.seqNoPrimaryTerm = value;
            return this;
        }

        public final Builder pit(@Nullable PointInTimeReference value) {
            this.pit = value;
            return this;
        }

        public final Builder pit(Function<PointInTimeReference.Builder, ObjectBuilder<PointInTimeReference>> fn) {
            return this.pit(fn.apply(new PointInTimeReference.Builder()).build());
        }

        public final Builder suggest(@Nullable Suggester value) {
            this.suggest = value;
            return this;
        }

        public final Builder suggest(Function<Suggester.Builder, ObjectBuilder<Suggester>> fn) {
            return this.suggest(fn.apply(new Suggester.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultisearchBody build() {
            this._checkSingleUse();
            return new MultisearchBody(this);
        }
    }
}

