/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KnnQuery
implements JsonpSerializable {
    private final String field;
    private final List<Double> queryVector;
    private final long k;
    private final long numCandidates;
    @Nullable
    private final Float boost;
    private final List<Query> filter;
    public static final JsonpDeserializer<KnnQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnQuery::setupKnnQueryDeserializer);

    private KnnQuery(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.queryVector = ApiTypeHelper.unmodifiableRequired(builder.queryVector, (Object)this, "queryVector");
        this.k = ApiTypeHelper.requireNonNull(builder.k, this, "k");
        this.numCandidates = ApiTypeHelper.requireNonNull(builder.numCandidates, this, "numCandidates");
        this.boost = builder.boost;
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
    }

    public static KnnQuery of(Function<Builder, ObjectBuilder<KnnQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    public final List<Double> queryVector() {
        return this.queryVector;
    }

    public final long k() {
        return this.k;
    }

    public final long numCandidates() {
        return this.numCandidates;
    }

    @Nullable
    public final Float boost() {
        return this.boost;
    }

    public final List<Query> filter() {
        return this.filter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.queryVector)) {
            generator.writeKey("query_vector");
            generator.writeStartArray();
            for (Double d : this.queryVector) {
                generator.write(d.doubleValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("k");
        generator.write(this.k);
        generator.writeKey("num_candidates");
        generator.write(this.numCandidates);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write((double)this.boost.floatValue());
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (Query query : this.filter) {
                query.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupKnnQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::queryVector, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "query_vector");
        op.add(Builder::k, JsonpDeserializer.longDeserializer(), "k");
        op.add(Builder::numCandidates, JsonpDeserializer.longDeserializer(), "num_candidates");
        op.add(Builder::boost, JsonpDeserializer.floatDeserializer(), "boost");
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "filter");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<KnnQuery> {
        private String field;
        private List<Double> queryVector;
        private Long k;
        private Long numCandidates;
        @Nullable
        private Float boost;
        @Nullable
        private List<Query> filter;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder queryVector(List<Double> list) {
            this.queryVector = Builder._listAddAll(this.queryVector, list);
            return this;
        }

        public final Builder queryVector(Double value, Double ... values) {
            this.queryVector = Builder._listAdd(this.queryVector, value, values);
            return this;
        }

        public final Builder k(long value) {
            this.k = value;
            return this;
        }

        public final Builder numCandidates(long value) {
            this.numCandidates = value;
            return this;
        }

        public final Builder boost(@Nullable Float value) {
            this.boost = value;
            return this;
        }

        public final Builder filter(List<Query> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        public final Builder filter(Query value, Query ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KnnQuery build() {
            this._checkSingleUse();
            return new KnnQuery(this);
        }
    }
}

