/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ShardFileSizeInfo
implements JsonpSerializable {
    private final String description;
    private final long sizeInBytes;
    @Nullable
    private final Long minSizeInBytes;
    @Nullable
    private final Long maxSizeInBytes;
    @Nullable
    private final Long averageSizeInBytes;
    @Nullable
    private final Long count;
    public static final JsonpDeserializer<ShardFileSizeInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardFileSizeInfo::setupShardFileSizeInfoDeserializer);

    private ShardFileSizeInfo(Builder builder) {
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, (Object)this, "sizeInBytes", 0L);
        this.minSizeInBytes = builder.minSizeInBytes;
        this.maxSizeInBytes = builder.maxSizeInBytes;
        this.averageSizeInBytes = builder.averageSizeInBytes;
        this.count = builder.count;
    }

    public static ShardFileSizeInfo of(Function<Builder, ObjectBuilder<ShardFileSizeInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String description() {
        return this.description;
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Nullable
    public final Long minSizeInBytes() {
        return this.minSizeInBytes;
    }

    @Nullable
    public final Long maxSizeInBytes() {
        return this.maxSizeInBytes;
    }

    @Nullable
    public final Long averageSizeInBytes() {
        return this.averageSizeInBytes;
    }

    @Nullable
    public final Long count() {
        return this.count;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        if (this.minSizeInBytes != null) {
            generator.writeKey("min_size_in_bytes");
            generator.write(this.minSizeInBytes.longValue());
        }
        if (this.maxSizeInBytes != null) {
            generator.writeKey("max_size_in_bytes");
            generator.write(this.maxSizeInBytes.longValue());
        }
        if (this.averageSizeInBytes != null) {
            generator.writeKey("average_size_in_bytes");
            generator.write(this.averageSizeInBytes.longValue());
        }
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupShardFileSizeInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
        op.add(Builder::minSizeInBytes, JsonpDeserializer.longDeserializer(), "min_size_in_bytes");
        op.add(Builder::maxSizeInBytes, JsonpDeserializer.longDeserializer(), "max_size_in_bytes");
        op.add(Builder::averageSizeInBytes, JsonpDeserializer.longDeserializer(), "average_size_in_bytes");
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardFileSizeInfo> {
        private String description;
        private Long sizeInBytes;
        @Nullable
        private Long minSizeInBytes;
        @Nullable
        private Long maxSizeInBytes;
        @Nullable
        private Long averageSizeInBytes;
        @Nullable
        private Long count;

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        public final Builder minSizeInBytes(@Nullable Long value) {
            this.minSizeInBytes = value;
            return this;
        }

        public final Builder maxSizeInBytes(@Nullable Long value) {
            this.maxSizeInBytes = value;
            return this;
        }

        public final Builder averageSizeInBytes(@Nullable Long value) {
            this.averageSizeInBytes = value;
            return this;
        }

        public final Builder count(@Nullable Long value) {
            this.count = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardFileSizeInfo build() {
            this._checkSingleUse();
            return new ShardFileSizeInfo(this);
        }
    }
}

