/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TemplateMapping
implements JsonpSerializable {
    private final Map<String, Alias> aliases;
    private final List<String> indexPatterns;
    private final TypeMapping mappings;
    private final int order;
    private final Map<String, JsonData> settings;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<TemplateMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TemplateMapping::setupTemplateMappingDeserializer);

    private TemplateMapping(Builder builder) {
        this.aliases = ApiTypeHelper.unmodifiableRequired(builder.aliases, (Object)this, "aliases");
        this.indexPatterns = ApiTypeHelper.unmodifiableRequired(builder.indexPatterns, (Object)this, "indexPatterns");
        this.mappings = ApiTypeHelper.requireNonNull(builder.mappings, this, "mappings");
        this.order = ApiTypeHelper.requireNonNull(builder.order, (Object)this, "order", 0);
        this.settings = ApiTypeHelper.unmodifiableRequired(builder.settings, (Object)this, "settings");
        this.version = builder.version;
    }

    public static TemplateMapping of(Function<Builder, ObjectBuilder<TemplateMapping>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Alias> aliases() {
        return this.aliases;
    }

    public final List<String> indexPatterns() {
        return this.indexPatterns;
    }

    public final TypeMapping mappings() {
        return this.mappings;
    }

    public final int order() {
        return this.order;
    }

    public final Map<String, JsonData> settings() {
        return this.settings;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartObject();
            for (Map.Entry entry : this.aliases.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Alias)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indexPatterns)) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String string : this.indexPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("mappings");
        this.mappings.serialize(generator, mapper);
        generator.writeKey("order");
        generator.write(this.order);
        if (ApiTypeHelper.isDefined(this.settings)) {
            generator.writeKey("settings");
            generator.writeStartObject();
            for (Map.Entry entry : this.settings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTemplateMappingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(Alias._DESERIALIZER), "aliases");
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns");
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings");
        op.add(Builder::order, JsonpDeserializer.integerDeserializer(), "order");
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "settings");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TemplateMapping> {
        private Map<String, Alias> aliases;
        private List<String> indexPatterns;
        private TypeMapping mappings;
        private Integer order;
        private Map<String, JsonData> settings;
        @Nullable
        private Long version;

        public final Builder aliases(Map<String, Alias> map) {
            this.aliases = Builder._mapPutAll(this.aliases, map);
            return this;
        }

        public final Builder aliases(String key, Alias value) {
            this.aliases = Builder._mapPut(this.aliases, key, value);
            return this;
        }

        public final Builder aliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.aliases(key, fn.apply(new Alias.Builder()).build());
        }

        public final Builder indexPatterns(List<String> list) {
            this.indexPatterns = Builder._listAddAll(this.indexPatterns, list);
            return this;
        }

        public final Builder indexPatterns(String value, String ... values) {
            this.indexPatterns = Builder._listAdd(this.indexPatterns, value, values);
            return this;
        }

        public final Builder mappings(TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public final Builder order(int value) {
            this.order = value;
            return this;
        }

        public final Builder settings(Map<String, JsonData> map) {
            this.settings = Builder._mapPutAll(this.settings, map);
            return this;
        }

        public final Builder settings(String key, JsonData value) {
            this.settings = Builder._mapPut(this.settings, key, value);
            return this;
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TemplateMapping build() {
            this._checkSingleUse();
            return new TemplateMapping(this);
        }
    }
}

