/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SpanFieldMaskingQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final String field;
    private final SpanQuery query;
    public static final JsonpDeserializer<SpanFieldMaskingQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanFieldMaskingQuery::setupSpanFieldMaskingQueryDeserializer);

    private SpanFieldMaskingQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
    }

    public static SpanFieldMaskingQuery of(Function<Builder, ObjectBuilder<SpanFieldMaskingQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.SpanFieldMasking;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.SpanFieldMasking;
    }

    public final String field() {
        return this.field;
    }

    public final SpanQuery query() {
        return this.query;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
    }

    protected static void setupSpanFieldMaskingQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::query, SpanQuery._DESERIALIZER, "query");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanFieldMaskingQuery> {
        private String field;
        private SpanQuery query;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder query(SpanQuery value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.query(fn.apply(new SpanQuery.Builder()).build());
        }

        public final Builder query(SpanQueryVariant value) {
            this.query = value._toSpanQuery();
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanFieldMaskingQuery build() {
            this._checkSingleUse();
            return new SpanFieldMaskingQuery(this);
        }
    }
}

