/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._helpers.esql.jdbc;

import co.elastic.clients.elasticsearch._helpers.esql.EsqlAdapterBase;
import co.elastic.clients.elasticsearch._helpers.esql.EsqlMetadata;
import co.elastic.clients.elasticsearch._helpers.esql.jdbc.Cursor;
import co.elastic.clients.elasticsearch._helpers.esql.jdbc.JdbcColumnInfo;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnexpectedJsonEventException;
import jakarta.json.stream.JsonParser;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

class JsonpCursor
implements Cursor {
    private final JsonParser parser;
    private final JsonpMapper mapper;
    private final List<JdbcColumnInfo> columns;
    private List<Object> record = new ArrayList<Object>();

    JsonpCursor(EsqlMetadata metadata, JsonParser parser, JsonpMapper mapper) {
        this.parser = parser;
        this.mapper = mapper;
        this.columns = metadata.columns.stream().map(col -> {
            try {
                return new JdbcColumnInfo(col.name(), col.type());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public List<JdbcColumnInfo> columns() {
        return this.columns;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.record == null) {
            return false;
        }
        JsonParser.Event event = this.parser.next();
        if (event != JsonParser.Event.START_ARRAY) {
            this.record = null;
            JsonpUtils.expectEvent(this.parser, JsonParser.Event.END_ARRAY, event);
            EsqlAdapterBase.readFooter(this.parser);
            return false;
        }
        this.record.clear();
        while ((event = this.parser.next()) != JsonParser.Event.END_ARRAY) {
            this.record.add(this.readValue(this.parser, event));
        }
        return true;
    }

    private Object readValue(JsonParser parser, JsonParser.Event event) {
        switch (event) {
            case VALUE_STRING: {
                return parser.getString();
            }
            case VALUE_NUMBER: {
                return parser.isIntegralNumber() ? (double)parser.getLong() : parser.getBigDecimal().doubleValue();
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_NULL: {
                return null;
            }
            case START_OBJECT: {
                HashMap<String, Object> map = new HashMap<String, Object>();
                while ((event = parser.next()) != JsonParser.Event.END_OBJECT) {
                    String key = JsonpUtils.expectKeyName(parser, event);
                    map.put(key, this.readValue(parser, parser.next()));
                }
                return map;
            }
            case START_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                while ((event = parser.next()) != JsonParser.Event.END_ARRAY) {
                    list.add(this.readValue(parser, event));
                }
                return list;
            }
        }
        throw new UnexpectedJsonEventException(parser, event);
    }

    @Override
    public Object column(int column) {
        return this.record.get(column);
    }

    @Override
    public int batchSize() {
        return 0;
    }

    @Override
    public void close() throws SQLException {
        while (this.next()) {
        }
    }

    @Override
    public List<String> warnings() {
        return Collections.emptyList();
    }

    @Override
    public void clearWarnings() {
    }
}

