/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class Phase
implements JsonpSerializable {
    private final List<String> actions;
    private final long minAge;
    public static final JsonpDeserializer<Phase> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Phase::setupPhaseDeserializer);

    private Phase(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiableRequired(builder.actions, (Object)this, "actions");
        this.minAge = ApiTypeHelper.requireNonNull(builder.minAge, this, "minAge");
    }

    public static Phase of(Function<Builder, ObjectBuilder<Phase>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> actions() {
        return this.actions;
    }

    public final long minAge() {
        return this.minAge;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actions)) {
            generator.writeKey("actions");
            generator.writeStartArray();
            for (String item0 : this.actions) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("min_age");
        generator.write(this.minAge);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPhaseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "actions");
        op.add(Builder::minAge, JsonpDeserializer.longDeserializer(), "min_age");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Phase> {
        private List<String> actions;
        private Long minAge;

        public final Builder actions(List<String> list) {
            this.actions = Builder._listAddAll(this.actions, list);
            return this;
        }

        public final Builder actions(String value, String ... values) {
            this.actions = Builder._listAdd(this.actions, value, values);
            return this;
        }

        public final Builder minAge(long value) {
            this.minAge = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Phase build() {
            this._checkSingleUse();
            return new Phase(this);
        }
    }
}

