/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.simulate;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.cluster.ComponentTemplateNode;
import co.elastic.clients.elasticsearch.indices.IndexTemplate;
import co.elastic.clients.elasticsearch.ingest.Document;
import co.elastic.clients.elasticsearch.ingest.Pipeline;
import co.elastic.clients.elasticsearch.simulate.IngestResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IngestRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, ComponentTemplateNode> componentTemplateSubstitutions;
    private final List<Document> docs;
    @Nullable
    private final String index;
    private final Map<String, IndexTemplate> indexTemplateSubstitutions;
    @Nullable
    private final TypeMapping mappingAddition;
    @Nullable
    private final String pipeline;
    private final Map<String, Pipeline> pipelineSubstitutions;
    public static final JsonpDeserializer<IngestRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IngestRequest::setupIngestRequestDeserializer);
    public static final Endpoint<IngestRequest, IngestResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<IngestRequest, IngestResponse>("es/simulate.ingest", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/_simulate");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_simulate");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("index", request.index);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.pipeline != null) {
            params.put("pipeline", request.pipeline);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, IngestResponse._DESERIALIZER);

    private IngestRequest(Builder builder) {
        this.componentTemplateSubstitutions = ApiTypeHelper.unmodifiable(builder.componentTemplateSubstitutions);
        this.docs = ApiTypeHelper.unmodifiableRequired(builder.docs, (Object)this, "docs");
        this.index = builder.index;
        this.indexTemplateSubstitutions = ApiTypeHelper.unmodifiable(builder.indexTemplateSubstitutions);
        this.mappingAddition = builder.mappingAddition;
        this.pipeline = builder.pipeline;
        this.pipelineSubstitutions = ApiTypeHelper.unmodifiable(builder.pipelineSubstitutions);
    }

    public static IngestRequest of(Function<Builder, ObjectBuilder<IngestRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, ComponentTemplateNode> componentTemplateSubstitutions() {
        return this.componentTemplateSubstitutions;
    }

    public final List<Document> docs() {
        return this.docs;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    public final Map<String, IndexTemplate> indexTemplateSubstitutions() {
        return this.indexTemplateSubstitutions;
    }

    @Nullable
    public final TypeMapping mappingAddition() {
        return this.mappingAddition;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    public final Map<String, Pipeline> pipelineSubstitutions() {
        return this.pipelineSubstitutions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.componentTemplateSubstitutions)) {
            generator.writeKey("component_template_substitutions");
            generator.writeStartObject();
            for (Map.Entry entry : this.componentTemplateSubstitutions.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ComponentTemplateNode)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.docs)) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (Document document : this.docs) {
                document.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indexTemplateSubstitutions)) {
            generator.writeKey("index_template_substitutions");
            generator.writeStartObject();
            for (Map.Entry entry : this.indexTemplateSubstitutions.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((IndexTemplate)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.mappingAddition != null) {
            generator.writeKey("mapping_addition");
            this.mappingAddition.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.pipelineSubstitutions)) {
            generator.writeKey("pipeline_substitutions");
            generator.writeStartObject();
            for (Map.Entry entry : this.pipelineSubstitutions.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Pipeline)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupIngestRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::componentTemplateSubstitutions, JsonpDeserializer.stringMapDeserializer(ComponentTemplateNode._DESERIALIZER), "component_template_substitutions");
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(Document._DESERIALIZER), "docs");
        op.add(Builder::indexTemplateSubstitutions, JsonpDeserializer.stringMapDeserializer(IndexTemplate._DESERIALIZER), "index_template_substitutions");
        op.add(Builder::mappingAddition, TypeMapping._DESERIALIZER, "mapping_addition");
        op.add(Builder::pipelineSubstitutions, JsonpDeserializer.stringMapDeserializer(Pipeline._DESERIALIZER), "pipeline_substitutions");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IngestRequest> {
        @Nullable
        private Map<String, ComponentTemplateNode> componentTemplateSubstitutions;
        private List<Document> docs;
        @Nullable
        private String index;
        @Nullable
        private Map<String, IndexTemplate> indexTemplateSubstitutions;
        @Nullable
        private TypeMapping mappingAddition;
        @Nullable
        private String pipeline;
        @Nullable
        private Map<String, Pipeline> pipelineSubstitutions;

        public final Builder componentTemplateSubstitutions(Map<String, ComponentTemplateNode> map) {
            this.componentTemplateSubstitutions = Builder._mapPutAll(this.componentTemplateSubstitutions, map);
            return this;
        }

        public final Builder componentTemplateSubstitutions(String key, ComponentTemplateNode value) {
            this.componentTemplateSubstitutions = Builder._mapPut(this.componentTemplateSubstitutions, key, value);
            return this;
        }

        public final Builder componentTemplateSubstitutions(String key, Function<ComponentTemplateNode.Builder, ObjectBuilder<ComponentTemplateNode>> fn) {
            return this.componentTemplateSubstitutions(key, fn.apply(new ComponentTemplateNode.Builder()).build());
        }

        public final Builder docs(List<Document> list) {
            this.docs = Builder._listAddAll(this.docs, list);
            return this;
        }

        public final Builder docs(Document value, Document ... values) {
            this.docs = Builder._listAdd(this.docs, value, values);
            return this;
        }

        public final Builder docs(Function<Document.Builder, ObjectBuilder<Document>> fn) {
            return this.docs(fn.apply(new Document.Builder()).build(), new Document[0]);
        }

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder indexTemplateSubstitutions(Map<String, IndexTemplate> map) {
            this.indexTemplateSubstitutions = Builder._mapPutAll(this.indexTemplateSubstitutions, map);
            return this;
        }

        public final Builder indexTemplateSubstitutions(String key, IndexTemplate value) {
            this.indexTemplateSubstitutions = Builder._mapPut(this.indexTemplateSubstitutions, key, value);
            return this;
        }

        public final Builder indexTemplateSubstitutions(String key, Function<IndexTemplate.Builder, ObjectBuilder<IndexTemplate>> fn) {
            return this.indexTemplateSubstitutions(key, fn.apply(new IndexTemplate.Builder()).build());
        }

        public final Builder mappingAddition(@Nullable TypeMapping value) {
            this.mappingAddition = value;
            return this;
        }

        public final Builder mappingAddition(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappingAddition(fn.apply(new TypeMapping.Builder()).build());
        }

        public final Builder pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        public final Builder pipelineSubstitutions(Map<String, Pipeline> map) {
            this.pipelineSubstitutions = Builder._mapPutAll(this.pipelineSubstitutions, map);
            return this;
        }

        public final Builder pipelineSubstitutions(String key, Pipeline value) {
            this.pipelineSubstitutions = Builder._mapPut(this.pipelineSubstitutions, key, value);
            return this;
        }

        public final Builder pipelineSubstitutions(String key, Function<Pipeline.Builder, ObjectBuilder<Pipeline>> fn) {
            return this.pipelineSubstitutions(key, fn.apply(new Pipeline.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IngestRequest build() {
            this._checkSingleUse();
            return new IngestRequest(this);
        }
    }
}

