/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysis;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisAnalyzedFields;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsAuthorization;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsDestination;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsSource;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutDataFrameAnalyticsResponse
implements JsonpSerializable {
    @Nullable
    private final DataframeAnalyticsAuthorization authorization;
    private final boolean allowLazyStart;
    private final DataframeAnalysis analysis;
    @Nullable
    private final DataframeAnalysisAnalyzedFields analyzedFields;
    private final long createTime;
    @Nullable
    private final String description;
    private final DataframeAnalyticsDestination dest;
    private final String id;
    private final int maxNumThreads;
    private final Map<String, JsonData> meta;
    private final String modelMemoryLimit;
    private final DataframeAnalyticsSource source;
    private final String version;
    public static final JsonpDeserializer<PutDataFrameAnalyticsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutDataFrameAnalyticsResponse::setupPutDataFrameAnalyticsResponseDeserializer);

    private PutDataFrameAnalyticsResponse(Builder builder) {
        this.authorization = builder.authorization;
        this.allowLazyStart = ApiTypeHelper.requireNonNull(builder.allowLazyStart, this, "allowLazyStart");
        this.analysis = ApiTypeHelper.requireNonNull(builder.analysis, this, "analysis");
        this.analyzedFields = builder.analyzedFields;
        this.createTime = ApiTypeHelper.requireNonNull(builder.createTime, this, "createTime");
        this.description = builder.description;
        this.dest = ApiTypeHelper.requireNonNull(builder.dest, this, "dest");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.maxNumThreads = ApiTypeHelper.requireNonNull(builder.maxNumThreads, this, "maxNumThreads");
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.modelMemoryLimit = ApiTypeHelper.requireNonNull(builder.modelMemoryLimit, this, "modelMemoryLimit");
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static PutDataFrameAnalyticsResponse of(Function<Builder, ObjectBuilder<PutDataFrameAnalyticsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DataframeAnalyticsAuthorization authorization() {
        return this.authorization;
    }

    public final boolean allowLazyStart() {
        return this.allowLazyStart;
    }

    public final DataframeAnalysis analysis() {
        return this.analysis;
    }

    @Nullable
    public final DataframeAnalysisAnalyzedFields analyzedFields() {
        return this.analyzedFields;
    }

    public final long createTime() {
        return this.createTime;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final DataframeAnalyticsDestination dest() {
        return this.dest;
    }

    public final String id() {
        return this.id;
    }

    public final int maxNumThreads() {
        return this.maxNumThreads;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    public final String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    public final DataframeAnalyticsSource source() {
        return this.source;
    }

    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.authorization != null) {
            generator.writeKey("authorization");
            this.authorization.serialize(generator, mapper);
        }
        generator.writeKey("allow_lazy_start");
        generator.write(this.allowLazyStart);
        generator.writeKey("analysis");
        this.analysis.serialize(generator, mapper);
        if (this.analyzedFields != null) {
            generator.writeKey("analyzed_fields");
            this.analyzedFields.serialize(generator, mapper);
        }
        generator.writeKey("create_time");
        generator.write(this.createTime);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("dest");
        this.dest.serialize(generator, mapper);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("max_num_threads");
        generator.write(this.maxNumThreads);
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("model_memory_limit");
        generator.write(this.modelMemoryLimit);
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
        generator.writeKey("version");
        generator.write(this.version);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPutDataFrameAnalyticsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::authorization, DataframeAnalyticsAuthorization._DESERIALIZER, "authorization");
        op.add(Builder::allowLazyStart, JsonpDeserializer.booleanDeserializer(), "allow_lazy_start");
        op.add(Builder::analysis, DataframeAnalysis._DESERIALIZER, "analysis");
        op.add(Builder::analyzedFields, DataframeAnalysisAnalyzedFields._DESERIALIZER, "analyzed_fields");
        op.add(Builder::createTime, JsonpDeserializer.longDeserializer(), "create_time");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::dest, DataframeAnalyticsDestination._DESERIALIZER, "dest");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::maxNumThreads, JsonpDeserializer.integerDeserializer(), "max_num_threads");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit");
        op.add(Builder::source, DataframeAnalyticsSource._DESERIALIZER, "source");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PutDataFrameAnalyticsResponse> {
        @Nullable
        private DataframeAnalyticsAuthorization authorization;
        private Boolean allowLazyStart;
        private DataframeAnalysis analysis;
        @Nullable
        private DataframeAnalysisAnalyzedFields analyzedFields;
        private Long createTime;
        @Nullable
        private String description;
        private DataframeAnalyticsDestination dest;
        private String id;
        private Integer maxNumThreads;
        @Nullable
        private Map<String, JsonData> meta;
        private String modelMemoryLimit;
        private DataframeAnalyticsSource source;
        private String version;

        public final Builder authorization(@Nullable DataframeAnalyticsAuthorization value) {
            this.authorization = value;
            return this;
        }

        public final Builder authorization(Function<DataframeAnalyticsAuthorization.Builder, ObjectBuilder<DataframeAnalyticsAuthorization>> fn) {
            return this.authorization(fn.apply(new DataframeAnalyticsAuthorization.Builder()).build());
        }

        public final Builder allowLazyStart(boolean value) {
            this.allowLazyStart = value;
            return this;
        }

        public final Builder analysis(DataframeAnalysis value) {
            this.analysis = value;
            return this;
        }

        public final Builder analysis(Function<DataframeAnalysis.Builder, ObjectBuilder<DataframeAnalysis>> fn) {
            return this.analysis(fn.apply(new DataframeAnalysis.Builder()).build());
        }

        public final Builder analyzedFields(@Nullable DataframeAnalysisAnalyzedFields value) {
            this.analyzedFields = value;
            return this;
        }

        public final Builder analyzedFields(Function<DataframeAnalysisAnalyzedFields.Builder, ObjectBuilder<DataframeAnalysisAnalyzedFields>> fn) {
            return this.analyzedFields(fn.apply(new DataframeAnalysisAnalyzedFields.Builder()).build());
        }

        public final Builder createTime(long value) {
            this.createTime = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder dest(DataframeAnalyticsDestination value) {
            this.dest = value;
            return this;
        }

        public final Builder dest(Function<DataframeAnalyticsDestination.Builder, ObjectBuilder<DataframeAnalyticsDestination>> fn) {
            return this.dest(fn.apply(new DataframeAnalyticsDestination.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder maxNumThreads(int value) {
            this.maxNumThreads = value;
            return this;
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder modelMemoryLimit(String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        public final Builder source(DataframeAnalyticsSource value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<DataframeAnalyticsSource.Builder, ObjectBuilder<DataframeAnalyticsSource>> fn) {
            return this.source(fn.apply(new DataframeAnalyticsSource.Builder()).build());
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutDataFrameAnalyticsResponse build() {
            this._checkSingleUse();
            return new PutDataFrameAnalyticsResponse(this);
        }
    }
}

