/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.TranslogDurability;
import co.elastic.clients.elasticsearch.indices.TranslogRetention;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Translog
implements JsonpSerializable {
    @Nullable
    private final Time syncInterval;
    @Nullable
    private final TranslogDurability durability;
    @Nullable
    private final String flushThresholdSize;
    @Nullable
    private final TranslogRetention retention;
    public static final JsonpDeserializer<Translog> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Translog::setupTranslogDeserializer);

    private Translog(Builder builder) {
        this.syncInterval = builder.syncInterval;
        this.durability = builder.durability;
        this.flushThresholdSize = builder.flushThresholdSize;
        this.retention = builder.retention;
    }

    public static Translog of(Function<Builder, ObjectBuilder<Translog>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time syncInterval() {
        return this.syncInterval;
    }

    @Nullable
    public final TranslogDurability durability() {
        return this.durability;
    }

    @Nullable
    public final String flushThresholdSize() {
        return this.flushThresholdSize;
    }

    @Nullable
    public final TranslogRetention retention() {
        return this.retention;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.syncInterval != null) {
            generator.writeKey("sync_interval");
            this.syncInterval.serialize(generator, mapper);
        }
        if (this.durability != null) {
            generator.writeKey("durability");
            this.durability.serialize(generator, mapper);
        }
        if (this.flushThresholdSize != null) {
            generator.writeKey("flush_threshold_size");
            generator.write(this.flushThresholdSize);
        }
        if (this.retention != null) {
            generator.writeKey("retention");
            this.retention.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTranslogDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::syncInterval, Time._DESERIALIZER, "sync_interval");
        op.add(Builder::durability, TranslogDurability._DESERIALIZER, "durability");
        op.add(Builder::flushThresholdSize, JsonpDeserializer.stringDeserializer(), "flush_threshold_size");
        op.add(Builder::retention, TranslogRetention._DESERIALIZER, "retention");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Translog> {
        @Nullable
        private Time syncInterval;
        @Nullable
        private TranslogDurability durability;
        @Nullable
        private String flushThresholdSize;
        @Nullable
        private TranslogRetention retention;

        public final Builder syncInterval(@Nullable Time value) {
            this.syncInterval = value;
            return this;
        }

        public final Builder syncInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.syncInterval(fn.apply(new Time.Builder()).build());
        }

        public final Builder durability(@Nullable TranslogDurability value) {
            this.durability = value;
            return this;
        }

        public final Builder flushThresholdSize(@Nullable String value) {
            this.flushThresholdSize = value;
            return this;
        }

        public final Builder retention(@Nullable TranslogRetention value) {
            this.retention = value;
            return this;
        }

        public final Builder retention(Function<TranslogRetention.Builder, ObjectBuilder<TranslogRetention>> fn) {
            return this.retention(fn.apply(new TranslogRetention.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Translog build() {
            this._checkSingleUse();
            return new Translog(this);
        }
    }
}

