/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.CatTrainedModelsColumn;
import co.elastic.clients.elasticsearch.cat.MlTrainedModelsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MlTrainedModelsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final Integer from;
    private final List<CatTrainedModelsColumn> h;
    @Nullable
    private final String modelId;
    private final List<CatTrainedModelsColumn> s;
    @Nullable
    private final Integer size;
    @Nullable
    private final TimeUnit time;
    public static final Endpoint<MlTrainedModelsRequest, MlTrainedModelsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MlTrainedModelsRequest, MlTrainedModelsResponse>("es/cat.ml_trained_models", request -> "GET", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (request.modelId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/trained_models");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _modelId = true;
        boolean propsSet = false;
        if (request.modelId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("modelId", request.modelId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (ApiTypeHelper.isDefined(request.s)) {
            params.put("s", request.s.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (ApiTypeHelper.isDefined(request.h)) {
            params.put("h", request.h.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.time != null) {
            params.put("time", request.time.jsonValue());
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlTrainedModelsResponse._DESERIALIZER);

    private MlTrainedModelsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.bytes = builder.bytes;
        this.from = builder.from;
        this.h = ApiTypeHelper.unmodifiable(builder.h);
        this.modelId = builder.modelId;
        this.s = ApiTypeHelper.unmodifiable(builder.s);
        this.size = builder.size;
        this.time = builder.time;
    }

    public static MlTrainedModelsRequest of(Function<Builder, ObjectBuilder<MlTrainedModelsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    public final List<CatTrainedModelsColumn> h() {
        return this.h;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    public final List<CatTrainedModelsColumn> s() {
        return this.s;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MlTrainedModelsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Bytes bytes;
        @Nullable
        private Integer from;
        @Nullable
        private List<CatTrainedModelsColumn> h;
        @Nullable
        private String modelId;
        @Nullable
        private List<CatTrainedModelsColumn> s;
        @Nullable
        private Integer size;
        @Nullable
        private TimeUnit time;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder h(List<CatTrainedModelsColumn> list) {
            this.h = Builder._listAddAll(this.h, list);
            return this;
        }

        public final Builder h(CatTrainedModelsColumn value, CatTrainedModelsColumn ... values) {
            this.h = Builder._listAdd(this.h, value, values);
            return this;
        }

        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        public final Builder s(List<CatTrainedModelsColumn> list) {
            this.s = Builder._listAddAll(this.s, list);
            return this;
        }

        public final Builder s(CatTrainedModelsColumn value, CatTrainedModelsColumn ... values) {
            this.s = Builder._listAdd(this.s, value, values);
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MlTrainedModelsRequest build() {
            this._checkSingleUse();
            return new MlTrainedModelsRequest(this);
        }
    }
}

