/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.ComponentTemplatesResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ComponentTemplatesRequest
extends CatRequestBase {
    @Nullable
    private final Boolean local;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final String name;
    public static final Endpoint<ComponentTemplatesRequest, ComponentTemplatesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ComponentTemplatesRequest, ComponentTemplatesResponse>("es/cat.component_templates", request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/component_templates");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/component_templates");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("name", request.name);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ComponentTemplatesResponse._DESERIALIZER);

    private ComponentTemplatesRequest(Builder builder) {
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
        this.name = builder.name;
    }

    public static ComponentTemplatesRequest of(Function<Builder, ObjectBuilder<ComponentTemplatesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean local() {
        return this.local;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ComponentTemplatesRequest> {
        @Nullable
        private Boolean local;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private String name;

        public final Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ComponentTemplatesRequest build() {
            this._checkSingleUse();
            return new ComponentTemplatesRequest(this);
        }
    }
}

