/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverBase;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.FieldCollapse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StandardRetriever
extends RetrieverBase
implements RetrieverVariant {
    @Nullable
    private final Query query;
    private final List<FieldValue> searchAfter;
    @Nullable
    private final Integer terminateAfter;
    private final List<SortOptions> sort;
    @Nullable
    private final FieldCollapse collapse;
    public static final JsonpDeserializer<StandardRetriever> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StandardRetriever::setupStandardRetrieverDeserializer);

    private StandardRetriever(Builder builder) {
        super(builder);
        this.query = builder.query;
        this.searchAfter = ApiTypeHelper.unmodifiable(builder.searchAfter);
        this.terminateAfter = builder.terminateAfter;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
        this.collapse = builder.collapse;
    }

    public static StandardRetriever of(Function<Builder, ObjectBuilder<StandardRetriever>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Retriever.Kind _retrieverKind() {
        return Retriever.Kind.Standard;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    public final List<FieldValue> searchAfter() {
        return this.searchAfter;
    }

    @Nullable
    public final Integer terminateAfter() {
        return this.terminateAfter;
    }

    public final List<SortOptions> sort() {
        return this.sort;
    }

    @Nullable
    public final FieldCollapse collapse() {
        return this.collapse;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.searchAfter)) {
            generator.writeKey("search_after");
            generator.writeStartArray();
            for (FieldValue fieldValue : this.searchAfter) {
                fieldValue.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.terminateAfter != null) {
            generator.writeKey("terminate_after");
            generator.write(this.terminateAfter.intValue());
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (SortOptions sortOptions : this.sort) {
                sortOptions.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.collapse != null) {
            generator.writeKey("collapse");
            this.collapse.serialize(generator, mapper);
        }
    }

    protected static void setupStandardRetrieverDeserializer(ObjectDeserializer<Builder> op) {
        RetrieverBase.setupRetrieverBaseDeserializer(op);
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::searchAfter, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "search_after");
        op.add(Builder::terminateAfter, JsonpDeserializer.integerDeserializer(), "terminate_after");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(SortOptions._DESERIALIZER), "sort");
        op.add(Builder::collapse, FieldCollapse._DESERIALIZER, "collapse");
    }

    public static class Builder
    extends RetrieverBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StandardRetriever> {
        @Nullable
        private Query query;
        @Nullable
        private List<FieldValue> searchAfter;
        @Nullable
        private Integer terminateAfter;
        @Nullable
        private List<SortOptions> sort;
        @Nullable
        private FieldCollapse collapse;

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder searchAfter(List<FieldValue> list) {
            this.searchAfter = Builder._listAddAll(this.searchAfter, list);
            return this;
        }

        public final Builder searchAfter(FieldValue value, FieldValue ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, value, values);
            return this;
        }

        public final Builder searchAfter(String value, String ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (String v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.searchAfter = Builder._listAddAll(this.searchAfter, fieldValues);
            return this;
        }

        public final Builder searchAfter(long value, long ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (long v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.searchAfter = Builder._listAddAll(this.searchAfter, fieldValues);
            return this;
        }

        public final Builder searchAfter(double value, double ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (double v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.searchAfter = Builder._listAddAll(this.searchAfter, fieldValues);
            return this;
        }

        public final Builder searchAfter(boolean value, boolean ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (boolean v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.searchAfter = Builder._listAddAll(this.searchAfter, fieldValues);
            return this;
        }

        public final Builder searchAfter(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.searchAfter(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        public final Builder terminateAfter(@Nullable Integer value) {
            this.terminateAfter = value;
            return this;
        }

        public final Builder sort(List<SortOptions> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(SortOptions value, SortOptions ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
            return this.sort(fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        }

        public final Builder collapse(@Nullable FieldCollapse value) {
            this.collapse = value;
            return this;
        }

        public final Builder collapse(Function<FieldCollapse.Builder, ObjectBuilder<FieldCollapse>> fn) {
            return this.collapse(fn.apply(new FieldCollapse.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StandardRetriever build() {
            this._checkSingleUse();
            return new StandardRetriever(this);
        }
    }
}

