/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot.cleanup_repository;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CleanupRepositoryResults
implements JsonpSerializable {
    private final long deletedBlobs;
    private final long deletedBytes;
    public static final JsonpDeserializer<CleanupRepositoryResults> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CleanupRepositoryResults::setupCleanupRepositoryResultsDeserializer);

    private CleanupRepositoryResults(Builder builder) {
        this.deletedBlobs = ApiTypeHelper.requireNonNull(builder.deletedBlobs, this, "deletedBlobs");
        this.deletedBytes = ApiTypeHelper.requireNonNull(builder.deletedBytes, this, "deletedBytes");
    }

    public static CleanupRepositoryResults of(Function<Builder, ObjectBuilder<CleanupRepositoryResults>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long deletedBlobs() {
        return this.deletedBlobs;
    }

    public final long deletedBytes() {
        return this.deletedBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("deleted_blobs");
        generator.write(this.deletedBlobs);
        generator.writeKey("deleted_bytes");
        generator.write(this.deletedBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCleanupRepositoryResultsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::deletedBlobs, JsonpDeserializer.longDeserializer(), "deleted_blobs");
        op.add(Builder::deletedBytes, JsonpDeserializer.longDeserializer(), "deleted_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CleanupRepositoryResults> {
        private Long deletedBlobs;
        private Long deletedBytes;

        public final Builder deletedBlobs(long value) {
            this.deletedBlobs = value;
            return this;
        }

        public final Builder deletedBytes(long value) {
            this.deletedBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CleanupRepositoryResults build() {
            this._checkSingleUse();
            return new CleanupRepositoryResults(this);
        }
    }
}

