/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.RepositorySettingsBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SourceOnlyRepositorySettings
extends RepositorySettingsBase {
    @Nullable
    private final String delegateType;
    @Nullable
    private final Integer maxNumberOfSnapshots;
    @Nullable
    private final Boolean readOnly;
    public static final JsonpDeserializer<SourceOnlyRepositorySettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SourceOnlyRepositorySettings::setupSourceOnlyRepositorySettingsDeserializer);

    private SourceOnlyRepositorySettings(Builder builder) {
        super(builder);
        this.delegateType = builder.delegateType;
        this.maxNumberOfSnapshots = builder.maxNumberOfSnapshots;
        this.readOnly = builder.readOnly;
    }

    public static SourceOnlyRepositorySettings of(Function<Builder, ObjectBuilder<SourceOnlyRepositorySettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String delegateType() {
        return this.delegateType;
    }

    @Nullable
    public final Integer maxNumberOfSnapshots() {
        return this.maxNumberOfSnapshots;
    }

    @Nullable
    public final Boolean readOnly() {
        return this.readOnly;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.delegateType != null) {
            generator.writeKey("delegate_type");
            generator.write(this.delegateType);
        }
        if (this.maxNumberOfSnapshots != null) {
            generator.writeKey("max_number_of_snapshots");
            generator.write(this.maxNumberOfSnapshots.intValue());
        }
        if (this.readOnly != null) {
            generator.writeKey("read_only");
            generator.write(this.readOnly.booleanValue());
        }
    }

    protected static void setupSourceOnlyRepositorySettingsDeserializer(ObjectDeserializer<Builder> op) {
        RepositorySettingsBase.setupRepositorySettingsBaseDeserializer(op);
        op.add(Builder::delegateType, JsonpDeserializer.stringDeserializer(), "delegate_type");
        op.add(Builder::maxNumberOfSnapshots, JsonpDeserializer.integerDeserializer(), "max_number_of_snapshots");
        op.add(Builder::readOnly, JsonpDeserializer.booleanDeserializer(), "read_only", "readonly");
    }

    public static class Builder
    extends RepositorySettingsBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SourceOnlyRepositorySettings> {
        @Nullable
        private String delegateType;
        @Nullable
        private Integer maxNumberOfSnapshots;
        @Nullable
        private Boolean readOnly;

        public final Builder delegateType(@Nullable String value) {
            this.delegateType = value;
            return this;
        }

        public final Builder maxNumberOfSnapshots(@Nullable Integer value) {
            this.maxNumberOfSnapshots = value;
            return this;
        }

        public final Builder readOnly(@Nullable Boolean value) {
            this.readOnly = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SourceOnlyRepositorySettings build() {
            this._checkSingleUse();
            return new SourceOnlyRepositorySettings(this);
        }
    }
}

