/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SizeHttpHistogram
implements JsonpSerializable {
    private final long count;
    @Nullable
    private final Long geBytes;
    @Nullable
    private final Long ltBytes;
    public static final JsonpDeserializer<SizeHttpHistogram> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SizeHttpHistogram::setupSizeHttpHistogramDeserializer);

    private SizeHttpHistogram(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.geBytes = builder.geBytes;
        this.ltBytes = builder.ltBytes;
    }

    public static SizeHttpHistogram of(Function<Builder, ObjectBuilder<SizeHttpHistogram>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    @Nullable
    public final Long geBytes() {
        return this.geBytes;
    }

    @Nullable
    public final Long ltBytes() {
        return this.ltBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (this.geBytes != null) {
            generator.writeKey("ge_bytes");
            generator.write(this.geBytes.longValue());
        }
        if (this.ltBytes != null) {
            generator.writeKey("lt_bytes");
            generator.write(this.ltBytes.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSizeHttpHistogramDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::geBytes, JsonpDeserializer.longDeserializer(), "ge_bytes");
        op.add(Builder::ltBytes, JsonpDeserializer.longDeserializer(), "lt_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SizeHttpHistogram> {
        private Long count;
        @Nullable
        private Long geBytes;
        @Nullable
        private Long ltBytes;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder geBytes(@Nullable Long value) {
            this.geBytes = value;
            return this;
        }

        public final Builder ltBytes(@Nullable Long value) {
            this.ltBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SizeHttpHistogram build() {
            this._checkSingleUse();
            return new SizeHttpHistogram(this);
        }
    }
}

