/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.SizeHttpHistogram;
import co.elastic.clients.elasticsearch.nodes.TimeHttpHistogram;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class HttpRouteResponses
implements JsonpSerializable {
    private final long count;
    private final long totalSizeInBytes;
    private final List<TimeHttpHistogram> handlingTimeHistogram;
    private final List<SizeHttpHistogram> sizeHistogram;
    public static final JsonpDeserializer<HttpRouteResponses> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HttpRouteResponses::setupHttpRouteResponsesDeserializer);

    private HttpRouteResponses(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.totalSizeInBytes = ApiTypeHelper.requireNonNull(builder.totalSizeInBytes, this, "totalSizeInBytes");
        this.handlingTimeHistogram = ApiTypeHelper.unmodifiableRequired(builder.handlingTimeHistogram, (Object)this, "handlingTimeHistogram");
        this.sizeHistogram = ApiTypeHelper.unmodifiableRequired(builder.sizeHistogram, (Object)this, "sizeHistogram");
    }

    public static HttpRouteResponses of(Function<Builder, ObjectBuilder<HttpRouteResponses>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public final List<TimeHttpHistogram> handlingTimeHistogram() {
        return this.handlingTimeHistogram;
    }

    public final List<SizeHttpHistogram> sizeHistogram() {
        return this.sizeHistogram;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("total_size_in_bytes");
        generator.write(this.totalSizeInBytes);
        if (ApiTypeHelper.isDefined(this.handlingTimeHistogram)) {
            generator.writeKey("handling_time_histogram");
            generator.writeStartArray();
            for (TimeHttpHistogram timeHttpHistogram : this.handlingTimeHistogram) {
                timeHttpHistogram.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.sizeHistogram)) {
            generator.writeKey("size_histogram");
            generator.writeStartArray();
            for (SizeHttpHistogram sizeHttpHistogram : this.sizeHistogram) {
                sizeHttpHistogram.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupHttpRouteResponsesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::totalSizeInBytes, JsonpDeserializer.longDeserializer(), "total_size_in_bytes");
        op.add(Builder::handlingTimeHistogram, JsonpDeserializer.arrayDeserializer(TimeHttpHistogram._DESERIALIZER), "handling_time_histogram");
        op.add(Builder::sizeHistogram, JsonpDeserializer.arrayDeserializer(SizeHttpHistogram._DESERIALIZER), "size_histogram");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HttpRouteResponses> {
        private Long count;
        private Long totalSizeInBytes;
        private List<TimeHttpHistogram> handlingTimeHistogram;
        private List<SizeHttpHistogram> sizeHistogram;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder totalSizeInBytes(long value) {
            this.totalSizeInBytes = value;
            return this;
        }

        public final Builder handlingTimeHistogram(List<TimeHttpHistogram> list) {
            this.handlingTimeHistogram = Builder._listAddAll(this.handlingTimeHistogram, list);
            return this;
        }

        public final Builder handlingTimeHistogram(TimeHttpHistogram value, TimeHttpHistogram ... values) {
            this.handlingTimeHistogram = Builder._listAdd(this.handlingTimeHistogram, value, values);
            return this;
        }

        public final Builder handlingTimeHistogram(Function<TimeHttpHistogram.Builder, ObjectBuilder<TimeHttpHistogram>> fn) {
            return this.handlingTimeHistogram(fn.apply(new TimeHttpHistogram.Builder()).build(), new TimeHttpHistogram[0]);
        }

        public final Builder sizeHistogram(List<SizeHttpHistogram> list) {
            this.sizeHistogram = Builder._listAddAll(this.sizeHistogram, list);
            return this;
        }

        public final Builder sizeHistogram(SizeHttpHistogram value, SizeHttpHistogram ... values) {
            this.sizeHistogram = Builder._listAdd(this.sizeHistogram, value, values);
            return this;
        }

        public final Builder sizeHistogram(Function<SizeHttpHistogram.Builder, ObjectBuilder<SizeHttpHistogram>> fn) {
            return this.sizeHistogram(fn.apply(new SizeHttpHistogram.Builder()).build(), new SizeHttpHistogram[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HttpRouteResponses build() {
            this._checkSingleUse();
            return new HttpRouteResponses(this);
        }
    }
}

