/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class GeoResults
implements JsonpSerializable {
    private final String actualPoint;
    private final String typicalPoint;
    public static final JsonpDeserializer<GeoResults> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoResults::setupGeoResultsDeserializer);

    private GeoResults(Builder builder) {
        this.actualPoint = ApiTypeHelper.requireNonNull(builder.actualPoint, this, "actualPoint");
        this.typicalPoint = ApiTypeHelper.requireNonNull(builder.typicalPoint, this, "typicalPoint");
    }

    public static GeoResults of(Function<Builder, ObjectBuilder<GeoResults>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String actualPoint() {
        return this.actualPoint;
    }

    public final String typicalPoint() {
        return this.typicalPoint;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actual_point");
        generator.write(this.actualPoint);
        generator.writeKey("typical_point");
        generator.write(this.typicalPoint);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGeoResultsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actualPoint, JsonpDeserializer.stringDeserializer(), "actual_point");
        op.add(Builder::typicalPoint, JsonpDeserializer.stringDeserializer(), "typical_point");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GeoResults> {
        private String actualPoint;
        private String typicalPoint;

        public final Builder actualPoint(String value) {
            this.actualPoint = value;
            return this;
        }

        public final Builder typicalPoint(String value) {
            this.typicalPoint = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoResults build() {
            this._checkSingleUse();
            return new GeoResults(this);
        }
    }
}

