/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RerouteProcessor
extends ProcessorBase
implements ProcessorVariant {
    @Nullable
    private final String destination;
    private final List<String> dataset;
    private final List<String> namespace;
    public static final JsonpDeserializer<RerouteProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteProcessor::setupRerouteProcessorDeserializer);

    private RerouteProcessor(Builder builder) {
        super(builder);
        this.destination = builder.destination;
        this.dataset = ApiTypeHelper.unmodifiable(builder.dataset);
        this.namespace = ApiTypeHelper.unmodifiable(builder.namespace);
    }

    public static RerouteProcessor of(Function<Builder, ObjectBuilder<RerouteProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Reroute;
    }

    @Nullable
    public final String destination() {
        return this.destination;
    }

    public final List<String> dataset() {
        return this.dataset;
    }

    public final List<String> namespace() {
        return this.namespace;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.destination != null) {
            generator.writeKey("destination");
            generator.write(this.destination);
        }
        if (ApiTypeHelper.isDefined(this.dataset)) {
            generator.writeKey("dataset");
            generator.writeStartArray();
            for (String item0 : this.dataset) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.namespace)) {
            generator.writeKey("namespace");
            generator.writeStartArray();
            for (String item0 : this.namespace) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRerouteProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::destination, JsonpDeserializer.stringDeserializer(), "destination");
        op.add(Builder::dataset, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "dataset");
        op.add(Builder::namespace, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "namespace");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RerouteProcessor> {
        @Nullable
        private String destination;
        @Nullable
        private List<String> dataset;
        @Nullable
        private List<String> namespace;

        public final Builder destination(@Nullable String value) {
            this.destination = value;
            return this;
        }

        public final Builder dataset(List<String> list) {
            this.dataset = Builder._listAddAll(this.dataset, list);
            return this;
        }

        public final Builder dataset(String value, String ... values) {
            this.dataset = Builder._listAdd(this.dataset, value, values);
            return this;
        }

        public final Builder namespace(List<String> list) {
            this.namespace = Builder._listAddAll(this.namespace, list);
            return this;
        }

        public final Builder namespace(String value, String ... values) {
            this.namespace = Builder._listAdd(this.namespace, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RerouteProcessor build() {
            this._checkSingleUse();
            return new RerouteProcessor(this);
        }
    }
}

