/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.resolve_cluster;

import co.elastic.clients.elasticsearch._types.ElasticsearchVersionMinInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ResolveClusterInfo
implements JsonpSerializable {
    private final boolean connected;
    private final boolean skipUnavailable;
    @Nullable
    private final Boolean matchingIndices;
    @Nullable
    private final String error;
    @Nullable
    private final ElasticsearchVersionMinInfo version;
    public static final JsonpDeserializer<ResolveClusterInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveClusterInfo::setupResolveClusterInfoDeserializer);

    private ResolveClusterInfo(Builder builder) {
        this.connected = ApiTypeHelper.requireNonNull(builder.connected, this, "connected");
        this.skipUnavailable = ApiTypeHelper.requireNonNull(builder.skipUnavailable, this, "skipUnavailable");
        this.matchingIndices = builder.matchingIndices;
        this.error = builder.error;
        this.version = builder.version;
    }

    public static ResolveClusterInfo of(Function<Builder, ObjectBuilder<ResolveClusterInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean connected() {
        return this.connected;
    }

    public final boolean skipUnavailable() {
        return this.skipUnavailable;
    }

    @Nullable
    public final Boolean matchingIndices() {
        return this.matchingIndices;
    }

    @Nullable
    public final String error() {
        return this.error;
    }

    @Nullable
    public final ElasticsearchVersionMinInfo version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("connected");
        generator.write(this.connected);
        generator.writeKey("skip_unavailable");
        generator.write(this.skipUnavailable);
        if (this.matchingIndices != null) {
            generator.writeKey("matching_indices");
            generator.write(this.matchingIndices.booleanValue());
        }
        if (this.error != null) {
            generator.writeKey("error");
            generator.write(this.error);
        }
        if (this.version != null) {
            generator.writeKey("version");
            this.version.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupResolveClusterInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connected, JsonpDeserializer.booleanDeserializer(), "connected");
        op.add(Builder::skipUnavailable, JsonpDeserializer.booleanDeserializer(), "skip_unavailable");
        op.add(Builder::matchingIndices, JsonpDeserializer.booleanDeserializer(), "matching_indices");
        op.add(Builder::error, JsonpDeserializer.stringDeserializer(), "error");
        op.add(Builder::version, ElasticsearchVersionMinInfo._DESERIALIZER, "version");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ResolveClusterInfo> {
        private Boolean connected;
        private Boolean skipUnavailable;
        @Nullable
        private Boolean matchingIndices;
        @Nullable
        private String error;
        @Nullable
        private ElasticsearchVersionMinInfo version;

        public final Builder connected(boolean value) {
            this.connected = value;
            return this;
        }

        public final Builder skipUnavailable(boolean value) {
            this.skipUnavailable = value;
            return this;
        }

        public final Builder matchingIndices(@Nullable Boolean value) {
            this.matchingIndices = value;
            return this;
        }

        public final Builder error(@Nullable String value) {
            this.error = value;
            return this;
        }

        public final Builder version(@Nullable ElasticsearchVersionMinInfo value) {
            this.version = value;
            return this;
        }

        public final Builder version(Function<ElasticsearchVersionMinInfo.Builder, ObjectBuilder<ElasticsearchVersionMinInfo>> fn) {
            return this.version(fn.apply(new ElasticsearchVersionMinInfo.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ResolveClusterInfo build() {
            this._checkSingleUse();
            return new ResolveClusterInfo(this);
        }
    }
}

