/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch._types.ClusterStatistics;
import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.core.search.Profile;
import co.elastic.clients.elasticsearch.core.search.Suggestion;
import co.elastic.clients.json.ExternallyTaggedUnion;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class ResponseBody<TDocument>
implements JsonpSerializable {
    private final long took;
    private final boolean timedOut;
    private final ShardStatistics shards;
    private final HitsMetadata<TDocument> hits;
    private final Map<String, Aggregate> aggregations;
    @Nullable
    private final ClusterStatistics clusters;
    private final Map<String, JsonData> fields;
    @Nullable
    private final Double maxScore;
    @Nullable
    private final Long numReducePhases;
    @Nullable
    private final Profile profile;
    @Nullable
    private final String pitId;
    @Nullable
    private final String scrollId;
    private final Map<String, List<Suggestion<TDocument>>> suggest;
    @Nullable
    private final Boolean terminatedEarly;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    protected ResponseBody(AbstractBuilder<TDocument, ?> builder) {
        this.took = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).took, this, "took");
        this.timedOut = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).timedOut, this, "timedOut");
        this.shards = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).shards, this, "shards");
        this.hits = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).hits, this, "hits");
        this.aggregations = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).aggregations);
        this.clusters = ((AbstractBuilder)builder).clusters;
        this.fields = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).fields);
        this.maxScore = ((AbstractBuilder)builder).maxScore;
        this.numReducePhases = ((AbstractBuilder)builder).numReducePhases;
        this.profile = ((AbstractBuilder)builder).profile;
        this.pitId = ((AbstractBuilder)builder).pitId;
        this.scrollId = ((AbstractBuilder)builder).scrollId;
        this.suggest = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).suggest);
        this.terminatedEarly = ((AbstractBuilder)builder).terminatedEarly;
        this.tDocumentSerializer = ((AbstractBuilder)builder).tDocumentSerializer;
    }

    public final long took() {
        return this.took;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    public final HitsMetadata<TDocument> hits() {
        return this.hits;
    }

    public final Map<String, Aggregate> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final ClusterStatistics clusters() {
        return this.clusters;
    }

    public final Map<String, JsonData> fields() {
        return this.fields;
    }

    @Nullable
    public final Double maxScore() {
        return this.maxScore;
    }

    @Nullable
    public final Long numReducePhases() {
        return this.numReducePhases;
    }

    @Nullable
    public final Profile profile() {
        return this.profile;
    }

    @Nullable
    public final String pitId() {
        return this.pitId;
    }

    @Nullable
    public final String scrollId() {
        return this.scrollId;
    }

    public final Map<String, List<Suggestion<TDocument>>> suggest() {
        return this.suggest;
    }

    @Nullable
    public final Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("took");
        generator.write(this.took);
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            ExternallyTaggedUnion.serializeTypedKeys(this.aggregations, generator, mapper);
        }
        if (this.clusters != null) {
            generator.writeKey("_clusters");
            this.clusters.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxScore != null) {
            generator.writeKey("max_score");
            generator.write(this.maxScore.doubleValue());
        }
        if (this.numReducePhases != null) {
            generator.writeKey("num_reduce_phases");
            generator.write(this.numReducePhases.longValue());
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            this.profile.serialize(generator, mapper);
        }
        if (this.pitId != null) {
            generator.writeKey("pit_id");
            generator.write(this.pitId);
        }
        if (this.scrollId != null) {
            generator.writeKey("_scroll_id");
            generator.write(this.scrollId);
        }
        if (ApiTypeHelper.isDefined(this.suggest)) {
            generator.writeKey("suggest");
            ExternallyTaggedUnion.serializeTypedKeysArray(this.suggest, generator, mapper);
        }
        if (this.terminatedEarly != null) {
            generator.writeKey("terminated_early");
            generator.write(this.terminatedEarly.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>> void setupResponseBodyDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(AbstractBuilder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(AbstractBuilder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(AbstractBuilder::hits, HitsMetadata.createHitsMetadataDeserializer(tDocumentDeserializer), "hits");
        op.add(AbstractBuilder::aggregations, Aggregate._TYPED_KEYS_DESERIALIZER, "aggregations");
        op.add(AbstractBuilder::clusters, ClusterStatistics._DESERIALIZER, "_clusters");
        op.add(AbstractBuilder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields");
        op.add(AbstractBuilder::maxScore, JsonpDeserializer.doubleDeserializer(), "max_score");
        op.add(AbstractBuilder::numReducePhases, JsonpDeserializer.longDeserializer(), "num_reduce_phases");
        op.add(AbstractBuilder::profile, Profile._DESERIALIZER, "profile");
        op.add(AbstractBuilder::pitId, JsonpDeserializer.stringDeserializer(), "pit_id");
        op.add(AbstractBuilder::scrollId, JsonpDeserializer.stringDeserializer(), "_scroll_id");
        op.add(AbstractBuilder::suggest, ExternallyTaggedUnion.arrayMapDeserializer(Suggestion.createSuggestionDeserializer(tDocumentDeserializer)), "suggest");
        op.add(AbstractBuilder::terminatedEarly, JsonpDeserializer.booleanDeserializer(), "terminated_early");
    }

    public static abstract class AbstractBuilder<TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private Long took;
        private Boolean timedOut;
        private ShardStatistics shards;
        private HitsMetadata<TDocument> hits;
        @Nullable
        private Map<String, Aggregate> aggregations;
        @Nullable
        private ClusterStatistics clusters;
        @Nullable
        private Map<String, JsonData> fields;
        @Nullable
        private Double maxScore;
        @Nullable
        private Long numReducePhases;
        @Nullable
        private Profile profile;
        @Nullable
        private String pitId;
        @Nullable
        private String scrollId;
        @Nullable
        private Map<String, List<Suggestion<TDocument>>> suggest;
        @Nullable
        private Boolean terminatedEarly;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final BuilderT took(long value) {
            this.took = value;
            return (BuilderT)this.self();
        }

        public final BuilderT timedOut(boolean value) {
            this.timedOut = value;
            return (BuilderT)this.self();
        }

        public final BuilderT shards(ShardStatistics value) {
            this.shards = value;
            return (BuilderT)this.self();
        }

        public final BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final BuilderT hits(HitsMetadata<TDocument> value) {
            this.hits = value;
            return (BuilderT)this.self();
        }

        public final BuilderT hits(Function<HitsMetadata.Builder<TDocument>, ObjectBuilder<HitsMetadata<TDocument>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        public final BuilderT aggregations(Map<String, Aggregate> map) {
            this.aggregations = AbstractBuilder._mapPutAll(this.aggregations, map);
            return (BuilderT)this.self();
        }

        public final BuilderT aggregations(String key, Aggregate value) {
            this.aggregations = AbstractBuilder._mapPut(this.aggregations, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT aggregations(String key, Function<Aggregate.Builder, ObjectBuilder<Aggregate>> fn) {
            return this.aggregations(key, fn.apply(new Aggregate.Builder()).build());
        }

        public final BuilderT clusters(@Nullable ClusterStatistics value) {
            this.clusters = value;
            return (BuilderT)this.self();
        }

        public final BuilderT clusters(Function<ClusterStatistics.Builder, ObjectBuilder<ClusterStatistics>> fn) {
            return this.clusters(fn.apply(new ClusterStatistics.Builder()).build());
        }

        public final BuilderT fields(Map<String, JsonData> map) {
            this.fields = AbstractBuilder._mapPutAll(this.fields, map);
            return (BuilderT)this.self();
        }

        public final BuilderT fields(String key, JsonData value) {
            this.fields = AbstractBuilder._mapPut(this.fields, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT maxScore(@Nullable Double value) {
            this.maxScore = value;
            return (BuilderT)this.self();
        }

        public final BuilderT numReducePhases(@Nullable Long value) {
            this.numReducePhases = value;
            return (BuilderT)this.self();
        }

        public final BuilderT profile(@Nullable Profile value) {
            this.profile = value;
            return (BuilderT)this.self();
        }

        public final BuilderT profile(Function<Profile.Builder, ObjectBuilder<Profile>> fn) {
            return this.profile(fn.apply(new Profile.Builder()).build());
        }

        public final BuilderT pitId(@Nullable String value) {
            this.pitId = value;
            return (BuilderT)this.self();
        }

        public final BuilderT scrollId(@Nullable String value) {
            this.scrollId = value;
            return (BuilderT)this.self();
        }

        public final BuilderT suggest(Map<String, List<Suggestion<TDocument>>> map) {
            this.suggest = AbstractBuilder._mapPutAll(this.suggest, map);
            return (BuilderT)this.self();
        }

        public final BuilderT suggest(String key, List<Suggestion<TDocument>> value) {
            this.suggest = AbstractBuilder._mapPut(this.suggest, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT terminatedEarly(@Nullable Boolean value) {
            this.terminatedEarly = value;
            return (BuilderT)this.self();
        }

        public final BuilderT tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

