/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.get_token.AuthenticatedUser;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetTokenResponse
implements JsonpSerializable {
    private final String accessToken;
    private final long expiresIn;
    @Nullable
    private final String scope;
    private final String type;
    @Nullable
    private final String refreshToken;
    @Nullable
    private final String kerberosAuthenticationResponseToken;
    private final AuthenticatedUser authentication;
    public static final JsonpDeserializer<GetTokenResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetTokenResponse::setupGetTokenResponseDeserializer);

    private GetTokenResponse(Builder builder) {
        this.accessToken = ApiTypeHelper.requireNonNull(builder.accessToken, this, "accessToken");
        this.expiresIn = ApiTypeHelper.requireNonNull(builder.expiresIn, this, "expiresIn");
        this.scope = builder.scope;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.refreshToken = builder.refreshToken;
        this.kerberosAuthenticationResponseToken = builder.kerberosAuthenticationResponseToken;
        this.authentication = ApiTypeHelper.requireNonNull(builder.authentication, this, "authentication");
    }

    public static GetTokenResponse of(Function<Builder, ObjectBuilder<GetTokenResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final long expiresIn() {
        return this.expiresIn;
    }

    @Nullable
    public final String scope() {
        return this.scope;
    }

    public final String type() {
        return this.type;
    }

    @Nullable
    public final String refreshToken() {
        return this.refreshToken;
    }

    @Nullable
    public final String kerberosAuthenticationResponseToken() {
        return this.kerberosAuthenticationResponseToken;
    }

    public final AuthenticatedUser authentication() {
        return this.authentication;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("access_token");
        generator.write(this.accessToken);
        generator.writeKey("expires_in");
        generator.write(this.expiresIn);
        if (this.scope != null) {
            generator.writeKey("scope");
            generator.write(this.scope);
        }
        generator.writeKey("type");
        generator.write(this.type);
        if (this.refreshToken != null) {
            generator.writeKey("refresh_token");
            generator.write(this.refreshToken);
        }
        if (this.kerberosAuthenticationResponseToken != null) {
            generator.writeKey("kerberos_authentication_response_token");
            generator.write(this.kerberosAuthenticationResponseToken);
        }
        generator.writeKey("authentication");
        this.authentication.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetTokenResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accessToken, JsonpDeserializer.stringDeserializer(), "access_token");
        op.add(Builder::expiresIn, JsonpDeserializer.longDeserializer(), "expires_in");
        op.add(Builder::scope, JsonpDeserializer.stringDeserializer(), "scope");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::refreshToken, JsonpDeserializer.stringDeserializer(), "refresh_token");
        op.add(Builder::kerberosAuthenticationResponseToken, JsonpDeserializer.stringDeserializer(), "kerberos_authentication_response_token");
        op.add(Builder::authentication, AuthenticatedUser._DESERIALIZER, "authentication");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetTokenResponse> {
        private String accessToken;
        private Long expiresIn;
        @Nullable
        private String scope;
        private String type;
        @Nullable
        private String refreshToken;
        @Nullable
        private String kerberosAuthenticationResponseToken;
        private AuthenticatedUser authentication;

        public final Builder accessToken(String value) {
            this.accessToken = value;
            return this;
        }

        public final Builder expiresIn(long value) {
            this.expiresIn = value;
            return this;
        }

        public final Builder scope(@Nullable String value) {
            this.scope = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder refreshToken(@Nullable String value) {
            this.refreshToken = value;
            return this;
        }

        public final Builder kerberosAuthenticationResponseToken(@Nullable String value) {
            this.kerberosAuthenticationResponseToken = value;
            return this;
        }

        public final Builder authentication(AuthenticatedUser value) {
            this.authentication = value;
            return this;
        }

        public final Builder authentication(Function<AuthenticatedUser.Builder, ObjectBuilder<AuthenticatedUser>> fn) {
            return this.authentication(fn.apply(new AuthenticatedUser.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetTokenResponse build() {
            this._checkSingleUse();
            return new GetTokenResponse(this);
        }
    }
}

