/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.InferenceEndpointInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetInferenceResponse
implements JsonpSerializable {
    private final List<InferenceEndpointInfo> endpoints;
    public static final JsonpDeserializer<GetInferenceResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetInferenceResponse::setupGetInferenceResponseDeserializer);

    private GetInferenceResponse(Builder builder) {
        this.endpoints = ApiTypeHelper.unmodifiableRequired(builder.endpoints, (Object)this, "endpoints");
    }

    public static GetInferenceResponse of(Function<Builder, ObjectBuilder<GetInferenceResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<InferenceEndpointInfo> endpoints() {
        return this.endpoints;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.endpoints)) {
            generator.writeKey("endpoints");
            generator.writeStartArray();
            for (InferenceEndpointInfo item0 : this.endpoints) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetInferenceResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::endpoints, JsonpDeserializer.arrayDeserializer(InferenceEndpointInfo._DESERIALIZER), "endpoints");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetInferenceResponse> {
        private List<InferenceEndpointInfo> endpoints;

        public final Builder endpoints(List<InferenceEndpointInfo> list) {
            this.endpoints = Builder._listAddAll(this.endpoints, list);
            return this;
        }

        public final Builder endpoints(InferenceEndpointInfo value, InferenceEndpointInfo ... values) {
            this.endpoints = Builder._listAdd(this.endpoints, value, values);
            return this;
        }

        public final Builder endpoints(Function<InferenceEndpointInfo.Builder, ObjectBuilder<InferenceEndpointInfo>> fn) {
            return this.endpoints(fn.apply(new InferenceEndpointInfo.Builder()).build(), new InferenceEndpointInfo[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetInferenceResponse build() {
            this._checkSingleUse();
            return new GetInferenceResponse(this);
        }
    }
}

