/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._helpers.esql;

import co.elastic.clients.elasticsearch._helpers.esql.EsqlAdapter;
import co.elastic.clients.elasticsearch._helpers.esql.EsqlMetadata;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMappingException;
import co.elastic.clients.json.JsonpUtils;
import jakarta.json.stream.JsonParser;
import java.util.List;

public abstract class EsqlAdapterBase<T>
implements EsqlAdapter<T> {
    public static EsqlMetadata readHeader(JsonParser parser, JsonpMapper mapper) {
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.START_OBJECT);
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.KEY_NAME);
        if (!"columns".equals(parser.getString())) {
            throw new JsonpMappingException("Expecting a 'columns' property, but found '" + parser.getString() + "'", parser.getLocation());
        }
        List<EsqlMetadata.EsqlColumn> columns = JsonpDeserializer.arrayDeserializer(EsqlMetadata.EsqlColumn._DESERIALIZER).deserialize(parser, mapper);
        EsqlMetadata result = new EsqlMetadata();
        result.columns = columns;
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.KEY_NAME);
        if (!"values".equals(parser.getString())) {
            throw new JsonpMappingException("Expecting a 'values' property, but found '" + parser.getString() + "'", parser.getLocation());
        }
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.START_ARRAY);
        return result;
    }

    public static void readFooter(JsonParser parser) {
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_OBJECT);
    }
}

