/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.aggregations.DateHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoTileGridAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.HistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregation;
import co.elastic.clients.elasticsearch.transform.PivotGroupByVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class PivotGroupBy
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<PivotGroupBy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PivotGroupBy::setupPivotGroupByDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public PivotGroupBy(PivotGroupByVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._pivotGroupByKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private PivotGroupBy(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static PivotGroupBy of(Function<Builder, ObjectBuilder<PivotGroupBy>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isDateHistogram() {
        return this._kind == Kind.DateHistogram;
    }

    public DateHistogramAggregation dateHistogram() {
        return (DateHistogramAggregation)TaggedUnionUtils.get(this, Kind.DateHistogram);
    }

    public boolean isGeotileGrid() {
        return this._kind == Kind.GeotileGrid;
    }

    public GeoTileGridAggregation geotileGrid() {
        return (GeoTileGridAggregation)TaggedUnionUtils.get(this, Kind.GeotileGrid);
    }

    public boolean isHistogram() {
        return this._kind == Kind.Histogram;
    }

    public HistogramAggregation histogram() {
        return (HistogramAggregation)TaggedUnionUtils.get(this, Kind.Histogram);
    }

    public boolean isTerms() {
        return this._kind == Kind.Terms;
    }

    public TermsAggregation terms() {
        return (TermsAggregation)TaggedUnionUtils.get(this, Kind.Terms);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPivotGroupByDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dateHistogram, DateHistogramAggregation._DESERIALIZER, "date_histogram");
        op.add(Builder::geotileGrid, GeoTileGridAggregation._DESERIALIZER, "geotile_grid");
        op.add(Builder::histogram, HistogramAggregation._DESERIALIZER, "histogram");
        op.add(Builder::terms, TermsAggregation._DESERIALIZER, "terms");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PivotGroupBy> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<PivotGroupBy> dateHistogram(DateHistogramAggregation v) {
            this._kind = Kind.DateHistogram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<PivotGroupBy> dateHistogram(Function<DateHistogramAggregation.Builder, ObjectBuilder<DateHistogramAggregation>> fn) {
            return this.dateHistogram(fn.apply(new DateHistogramAggregation.Builder()).build());
        }

        public ObjectBuilder<PivotGroupBy> geotileGrid(GeoTileGridAggregation v) {
            this._kind = Kind.GeotileGrid;
            this._value = v;
            return this;
        }

        public ObjectBuilder<PivotGroupBy> geotileGrid(Function<GeoTileGridAggregation.Builder, ObjectBuilder<GeoTileGridAggregation>> fn) {
            return this.geotileGrid(fn.apply(new GeoTileGridAggregation.Builder()).build());
        }

        public ObjectBuilder<PivotGroupBy> histogram(HistogramAggregation v) {
            this._kind = Kind.Histogram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<PivotGroupBy> histogram(Function<HistogramAggregation.Builder, ObjectBuilder<HistogramAggregation>> fn) {
            return this.histogram(fn.apply(new HistogramAggregation.Builder()).build());
        }

        public ObjectBuilder<PivotGroupBy> terms(TermsAggregation v) {
            this._kind = Kind.Terms;
            this._value = v;
            return this;
        }

        public ObjectBuilder<PivotGroupBy> terms(Function<TermsAggregation.Builder, ObjectBuilder<TermsAggregation>> fn) {
            return this.terms(fn.apply(new TermsAggregation.Builder()).build());
        }

        @Override
        public PivotGroupBy build() {
            this._checkSingleUse();
            return new PivotGroupBy(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        DateHistogram("date_histogram"),
        GeotileGrid("geotile_grid"),
        Histogram("histogram"),
        Terms("terms");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

