/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch.nodes.Http;
import co.elastic.clients.elasticsearch.nodes.Ingest;
import co.elastic.clients.elasticsearch.nodes.Scripting;
import co.elastic.clients.elasticsearch.nodes.ThreadCount;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterInfoResponse
implements JsonpSerializable {
    private final String clusterName;
    @Nullable
    private final Http http;
    @Nullable
    private final Ingest ingest;
    private final Map<String, ThreadCount> threadPool;
    @Nullable
    private final Scripting script;
    public static final JsonpDeserializer<ClusterInfoResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterInfoResponse::setupClusterInfoResponseDeserializer);

    private ClusterInfoResponse(Builder builder) {
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.http = builder.http;
        this.ingest = builder.ingest;
        this.threadPool = ApiTypeHelper.unmodifiable(builder.threadPool);
        this.script = builder.script;
    }

    public static ClusterInfoResponse of(Function<Builder, ObjectBuilder<ClusterInfoResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String clusterName() {
        return this.clusterName;
    }

    @Nullable
    public final Http http() {
        return this.http;
    }

    @Nullable
    public final Ingest ingest() {
        return this.ingest;
    }

    public final Map<String, ThreadCount> threadPool() {
        return this.threadPool;
    }

    @Nullable
    public final Scripting script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        if (this.http != null) {
            generator.writeKey("http");
            this.http.serialize(generator, mapper);
        }
        if (this.ingest != null) {
            generator.writeKey("ingest");
            this.ingest.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.threadPool)) {
            generator.writeKey("thread_pool");
            generator.writeStartObject();
            for (Map.Entry<String, ThreadCount> item0 : this.threadPool.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupClusterInfoResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::http, Http._DESERIALIZER, "http");
        op.add(Builder::ingest, Ingest._DESERIALIZER, "ingest");
        op.add(Builder::threadPool, JsonpDeserializer.stringMapDeserializer(ThreadCount._DESERIALIZER), "thread_pool");
        op.add(Builder::script, Scripting._DESERIALIZER, "script");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterInfoResponse> {
        private String clusterName;
        @Nullable
        private Http http;
        @Nullable
        private Ingest ingest;
        @Nullable
        private Map<String, ThreadCount> threadPool;
        @Nullable
        private Scripting script;

        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public final Builder http(@Nullable Http value) {
            this.http = value;
            return this;
        }

        public final Builder http(Function<Http.Builder, ObjectBuilder<Http>> fn) {
            return this.http(fn.apply(new Http.Builder()).build());
        }

        public final Builder ingest(@Nullable Ingest value) {
            this.ingest = value;
            return this;
        }

        public final Builder ingest(Function<Ingest.Builder, ObjectBuilder<Ingest>> fn) {
            return this.ingest(fn.apply(new Ingest.Builder()).build());
        }

        public final Builder threadPool(Map<String, ThreadCount> map) {
            this.threadPool = Builder._mapPutAll(this.threadPool, map);
            return this;
        }

        public final Builder threadPool(String key, ThreadCount value) {
            this.threadPool = Builder._mapPut(this.threadPool, key, value);
            return this;
        }

        public final Builder threadPool(String key, Function<ThreadCount.Builder, ObjectBuilder<ThreadCount>> fn) {
            return this.threadPool(key, fn.apply(new ThreadCount.Builder()).build());
        }

        public final Builder script(@Nullable Scripting value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Scripting.Builder, ObjectBuilder<Scripting>> fn) {
            return this.script(fn.apply(new Scripting.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterInfoResponse build() {
            this._checkSingleUse();
            return new ClusterInfoResponse(this);
        }
    }
}

