/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.http;

import cn.jpush.api.BaseResult;
import cn.jpush.api.CustomMessageParams;
import cn.jpush.api.ErrorCodeEnum;
import cn.jpush.api.MessageParams;
import cn.jpush.api.MessageResult;
import cn.jpush.api.MsgTypeEnum;
import cn.jpush.api.NotifyMessageParams;
import cn.jpush.api.SimpleHostnameVerifier;
import cn.jpush.api.SimpleTrustManager;
import cn.jpush.api.ValidateRequestParams;
import cn.jpush.http.BaseURL;
import cn.jpush.http.RequestTypeEnum;
import cn.jpush.http.StringUtils;
import com.google.gson.Gson;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class HttpClient {
    private static Logger logger = Logger.getLogger("HttpClient");
    private final String CHARSET = "UTF-8";
    private final int DEFAULT_CONNECTION_TIMEOUT = 20000;
    private final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private static Gson gson = new Gson();

    public MessageResult sendPush(String path, boolean enableSSL, MessageParams messageParams) {
        MessageResult messageResult = ValidateRequestParams.vidateParams(messageParams);
        if (messageResult != null) {
            return messageResult;
        }
        String pushResult = this.sendPost(path, enableSSL, this.parse(messageParams), RequestTypeEnum.PUSH.value(), null);
        return (MessageResult)gson.fromJson(pushResult, MessageResult.class);
    }

    public String sendReceived(String path, boolean enabledSSL, String params, String authCode) {
        path = path + "?msg_ids=" + params;
        return this.sendGet(path, enabledSSL, null, RequestTypeEnum.RECEIVE.value(), authCode);
    }

    private String sendGet(String path, boolean enabledSSL, String params, Integer reqeustType, String authCode) {
        return this.sendRequest(path, enabledSSL, params, "GET", reqeustType, authCode);
    }

    private String sendPost(String path, boolean enableSSL, String params, Integer reqeustType, String authCode) {
        return this.sendRequest(path, enableSSL, params, "POST", reqeustType, authCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendRequest(String path, boolean enableSSL, String params, String method, Integer reqeustType, String authCode) {
        StringBuffer sb;
        block32: {
            HttpURLConnection conn = null;
            FilterOutputStream outStream = null;
            sb = new StringBuffer();
            try {
                if (enableSSL) {
                    this.initSSL();
                }
                URL url = new URL(BaseURL.getUrlForPath(path, enableSSL, reqeustType));
                conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(20000);
                conn.setReadTimeout(30000);
                conn.setUseCaches(false);
                conn.setDoOutput(true);
                conn.setRequestMethod(method);
                conn.setRequestProperty("Connection", "Keep-Alive");
                conn.setRequestProperty("Charset", "UTF-8");
                if (authCode != null && !authCode.isEmpty()) {
                    conn.setRequestProperty("Authorization", authCode);
                }
                if (method.equals("POST")) {
                    byte[] data = params.getBytes("UTF-8");
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.setRequestProperty("Content-Length", String.valueOf(data.length));
                    outStream = new DataOutputStream(conn.getOutputStream());
                    outStream.write(data);
                    ((DataOutputStream)outStream).flush();
                }
                if (conn.getResponseCode() == 200) {
                    int len;
                    logger.info("Congratulations!The request was successful. response status is 200");
                    InputStream in = conn.getInputStream();
                    InputStreamReader reader = new InputStreamReader(in, "UTF-8");
                    char[] buff = new char[1024];
                    while ((len = reader.read(buff)) > 0) {
                        sb.append(buff, 0, len);
                    }
                    break block32;
                }
                logger.log(Level.WARNING, "Sorry!The request was fault. response status = " + conn.getResponseCode() + ",errormsg = " + conn.getHeaderField(0));
                String errmsg = "";
                errmsg = reqeustType.intValue() == RequestTypeEnum.RECEIVE.value() ? ((errmsg = ErrorCodeEnum.errorMsg(conn.getResponseCode())) == null ? conn.getHeaderField(0) : errmsg) : conn.getHeaderField(0);
                BaseResult result = new BaseResult(errmsg, conn.getResponseCode());
                String buff = result.toString();
                return buff;
            }
            catch (SocketTimeoutException e) {
                logger.log(Level.SEVERE, "God! the server throw SocketTimeout Exception.please check it out the error message:" + e.getMessage());
                BaseResult baseResult = new BaseResult(e.getMessage().toString(), ErrorCodeEnum.CONNECTIONTIMEOUT.value());
                String string = baseResult.toString();
                return string;
            }
            catch (ConnectException e) {
                logger.log(Level.SEVERE, "God! the server throw Connect Exception .please check it out the error message:" + e.getMessage());
                BaseResult baseResult = new BaseResult(e.getMessage().toString(), ErrorCodeEnum.CONNECTIONREFUSED.value());
                String string = baseResult.toString();
                return string;
            }
            catch (UnknownHostException e) {
                logger.log(Level.SEVERE, "God! the server throw UnknownHost Exception .please check it out the error message:" + e.getMessage());
                BaseResult baseResult = new BaseResult(e.getMessage().toString(), ErrorCodeEnum.CONNECTIONREFUSED.value());
                String string = baseResult.toString();
                return string;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "God! the server throw exception.please check it out the error message:" + e.getMessage());
                BaseResult baseResult = new BaseResult(e.getMessage().toString(), ErrorCodeEnum.UnknownException.value());
                String string = baseResult.toString();
                return string;
            }
            finally {
                if (null != outStream) {
                    try {
                        outStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (null != conn) {
                    conn.disconnect();
                }
            }
        }
        return sb.toString();
    }

    protected void initSSL() {
        try {
            TrustManager[] tmCerts = new TrustManager[]{new SimpleTrustManager()};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, tmCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            SimpleHostnameVerifier hv = new SimpleHostnameVerifier();
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String parse(MessageParams message) {
        String input = String.valueOf(message.getSendNo()) + message.getReceiverType().value() + message.getReceiverValue() + message.getMasterSecret();
        int msgType = 0;
        if (message instanceof NotifyMessageParams) {
            msgType = MsgTypeEnum.NOTIFY.value();
        } else if (message instanceof CustomMessageParams) {
            msgType = MsgTypeEnum.CUSTOM.value();
        }
        HashMap<String, String> nvPair = new HashMap<String, String>();
        nvPair.put("sendno", String.valueOf(message.getSendNo()));
        nvPair.put("app_key", message.getAppKey());
        nvPair.put("receiver_type", String.valueOf(message.getReceiverType().value()));
        nvPair.put("receiver_value", message.getReceiverValue());
        nvPair.put("verification_code", StringUtils.toMD5(input));
        nvPair.put("msg_type", String.valueOf(msgType));
        nvPair.put("msg_content", message.getMsgContent().toString());
        nvPair.put("platform", message.getPlatform());
        if (message.getTimeToLive() >= 0L) {
            nvPair.put("time_to_live", String.valueOf(message.getTimeToLive()));
        }
        if (null != message.getOverrideMsgId() && !"".equals(message.getOverrideMsgId())) {
            nvPair.put("override_msg_id", message.getOverrideMsgId());
        }
        return this.mapWithParms(nvPair);
    }

    protected String mapWithParms(Map<String, String> nvPair) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : nvPair.entrySet()) {
            builder.append(entry.getKey() + "=" + entry.getValue() + "&");
        }
        return builder.toString();
    }
}

