/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write.handler;

import cn.idev.excel.metadata.Head;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.write.handler.WriteHandler;
import cn.idev.excel.write.handler.context.CellWriteHandlerContext;
import cn.idev.excel.write.metadata.holder.WriteSheetHolder;
import cn.idev.excel.write.metadata.holder.WriteTableHolder;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public interface CellWriteHandler
extends WriteHandler {
    default public void beforeCellCreate(CellWriteHandlerContext context) {
        this.beforeCellCreate(context.getWriteSheetHolder(), context.getWriteTableHolder(), context.getRow(), context.getHeadData(), context.getColumnIndex(), context.getRelativeRowIndex(), context.getHead());
    }

    default public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer columnIndex, Integer relativeRowIndex, Boolean isHead) {
    }

    default public void afterCellCreate(CellWriteHandlerContext context) {
        this.afterCellCreate(context.getWriteSheetHolder(), context.getWriteTableHolder(), context.getCell(), context.getHeadData(), context.getRelativeRowIndex(), context.getHead());
    }

    default public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
    }

    default public void afterCellDataConverted(CellWriteHandlerContext context) {
        WriteCellData<?> writeCellData = CollectionUtils.isNotEmpty(context.getCellDataList()) ? context.getCellDataList().get(0) : null;
        this.afterCellDataConverted(context.getWriteSheetHolder(), context.getWriteTableHolder(), writeCellData, context.getCell(), context.getHeadData(), context.getRelativeRowIndex(), context.getHead());
    }

    default public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, WriteCellData<?> cellData, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
    }

    default public void afterCellDispose(CellWriteHandlerContext context) {
        this.afterCellDispose(context.getWriteSheetHolder(), context.getWriteTableHolder(), context.getCellDataList(), context.getCell(), context.getHeadData(), context.getRelativeRowIndex(), context.getHead());
    }

    default public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
    }
}

