/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.Month;
import cn.hutool.core.date.Quarter;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public final class YearQuarter
implements Comparable<YearQuarter>,
Serializable {
    private static final long serialVersionUID = 3804145964419489753L;
    private final int year;
    private final Quarter quarter;
    private final LocalDate firstDate;
    private final LocalDate lastDate;

    private YearQuarter(int year, Quarter quarter) {
        this.year = year;
        this.quarter = quarter;
        this.firstDate = quarter.firstMonthDay().atYear(year);
        this.lastDate = quarter.lastMonthDay().atYear(year);
    }

    public static YearQuarter of(int year, int quarter) {
        int yearValue = ChronoField.YEAR.checkValidIntValue(year);
        int quarterValue = Quarter.checkValidIntValue(quarter);
        return new YearQuarter(yearValue, Objects.requireNonNull(Quarter.of(quarterValue)));
    }

    public static YearQuarter of(int year, Quarter quarter) {
        return new YearQuarter(ChronoField.YEAR.checkValidIntValue(year), Objects.requireNonNull(quarter));
    }

    public static YearQuarter of(LocalDate date) {
        Objects.requireNonNull(date);
        return new YearQuarter(date.getYear(), Quarter.fromMonth(date.getMonthValue()));
    }

    public static YearQuarter of(Date date) {
        Objects.requireNonNull(date);
        int yearValue = ChronoField.YEAR.checkValidIntValue((long)date.getYear() + 1900L);
        int monthValue = date.getMonth() + 1;
        return new YearQuarter(yearValue, Quarter.fromMonth(monthValue));
    }

    public static YearQuarter of(Calendar date) {
        Objects.requireNonNull(date);
        int yearValue = ChronoField.YEAR.checkValidIntValue(date.get(1));
        int monthValue = date.get(2) + 1;
        return new YearQuarter(yearValue, Quarter.fromMonth(monthValue));
    }

    public static YearQuarter of(YearMonth yearMonth) {
        Objects.requireNonNull(yearMonth);
        return YearQuarter.of(yearMonth.getYear(), Quarter.fromMonth(yearMonth.getMonthValue()));
    }

    public static YearQuarter now() {
        return YearQuarter.of(LocalDate.now());
    }

    public int getYear() {
        return this.year;
    }

    public Quarter getQuarter() {
        return this.quarter;
    }

    public int getQuarterValue() {
        return this.quarter.getValue();
    }

    public YearMonth firstYearMonth() {
        return YearMonth.of(this.year, this.quarter.firstMonthValue());
    }

    public Month firstMonth() {
        return this.quarter.firstMonth();
    }

    public int firstMonthValue() {
        return this.quarter.firstMonthValue();
    }

    public YearMonth lastYearMonth() {
        return YearMonth.of(this.year, this.quarter.lastMonthValue());
    }

    public Month lastMonth() {
        return this.quarter.lastMonth();
    }

    public int lastMonthValue() {
        return this.quarter.lastMonthValue();
    }

    public LocalDate firstDate() {
        return this.firstDate;
    }

    public LocalDate lastDate() {
        return this.lastDate;
    }

    public YearQuarter plusQuarters(long quartersToAdd) {
        if (quartersToAdd == 0L) {
            return this;
        }
        long quarterCount = (long)this.year * 4L + (long)(this.quarter.getValue() - 1);
        long calcQuarters = quarterCount + quartersToAdd;
        int newYear = ChronoField.YEAR.checkValidIntValue(Math.floorDiv(calcQuarters, 4L));
        int newQuarter = (int)Math.floorMod(calcQuarters, 4L) + 1;
        return new YearQuarter(newYear, Objects.requireNonNull(Quarter.of(newQuarter)));
    }

    public YearQuarter minusQuarters(long quartersToMinus) {
        return this.plusQuarters(-quartersToMinus);
    }

    public YearQuarter nextQuarter() {
        return this.plusQuarters(1L);
    }

    public YearQuarter lastQuarter() {
        return this.minusQuarters(1L);
    }

    public YearQuarter plusYears(long yearsToAdd) {
        if (yearsToAdd == 0L) {
            return this;
        }
        int newYear = ChronoField.YEAR.checkValidIntValue((long)this.year + yearsToAdd);
        return new YearQuarter(newYear, this.quarter);
    }

    public YearQuarter minusYears(long yearsToMinus) {
        return this.plusYears(-yearsToMinus);
    }

    public YearQuarter nextYear() {
        return this.plusYears(1L);
    }

    public YearQuarter lastYear() {
        return this.minusYears(1L);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.year, this.quarter});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        YearQuarter other = (YearQuarter)obj;
        return this.year == other.year && this.quarter == other.quarter;
    }

    @Override
    public int compareTo(YearQuarter other) {
        int cmp = this.year - other.year;
        if (cmp == 0) {
            cmp = this.quarter.compareTo(other.quarter);
        }
        return cmp;
    }

    public boolean isBefore(YearQuarter other) {
        return this.compareTo(other) < 0;
    }

    public boolean isAfter(YearQuarter other) {
        return this.compareTo(other) > 0;
    }

    public String toString() {
        return this.year + " " + this.quarter.name();
    }
}

